/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.fuiou.request.settlement;

import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.fuiou.enums.settlement.FuiouSettlementApiDefinitionEnum;
import com.fshows.fuiou.request.base.FuiouBizRequest;
import com.fshows.fuiou.response.settlement.FuiouQuerySettlementResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author zhaoxumin
 * @version FuiouQuerySettlementRequest.java, v 0.1 2024-01-07 zhaoxumin
 */
@Data
public class FuiouQuerySettlementRequest extends FuiouBizRequest<FuiouQuerySettlementResponse, FuiouSettlementApiDefinitionEnum> implements Serializable {

    private static final long serialVersionUID = -8832628073250049195L;
    /**
     * 商户号, 富友分配的商户号
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 15, message = "mchntCd长度不能超过15")
    @JSONField(name = "mchnt_cd")
    private String mchntCd;

    /**
     * 商户内部提现单号
     */
    @Length(max = 30, message = "reserved_order_no长度不能超过30")
    @JSONField(name = "reserved_order_no")
    private String reservedOrderNo;

    /**
     * 随机字符串1
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 30, message = "mchntOrderNo长度不能超过30")
    @JSONField(name = "mchnt_order_no")
    private String mchntOrderNo;

    /**
     * 查询日期（yyyyMMdd）
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 8, message = "date长度不能超过8")
    private String date;

    /**
     * 分页开始序号
     *
     * (必填)
     */
    @NotNull
    @JSONField(name = "start_index")
    private Integer startIndex;

    /**
     * 分页结束序号
     *
     * (必填)
     */
    @NotNull
    @JSONField(name = "end_index")
    private Integer endIndex;

    /**
     * 富友本地跟踪号, 结算响应的富友本地跟踪号，用于查询单笔结算交易（与withdraw_type字段必须填其中一个字段）
     *
     * (非必填)
     */
    @Length(max = 28, message = "fyTraceNo长度不能超过28")
    @JSONField(name = "fy_trace_no")
    private String fyTraceNo;

    /**
     * 1：已转结余额结算
     * 2：D0手动结算
     * 3：钱包次日到账
     * 4：钱包即时到账
     * 5：合并结算
     * （与fy_trace_no字段必须填其中一个字段）
     *
     * (非必填)
     */
    @Length(max = 1, message = "withdrawType长度不能超过1")
    @JSONField(name = "withdraw_type")
    private String withdrawType;
}