/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.fuiou.request.merchant;

import com.fshows.fuiou.enums.merchant.FuiouMerchantApiDefinitionEnum;
import com.fshows.fuiou.request.base.FuiouBizRequest;
import com.fshows.fuiou.response.merchant.FuiouMerchantIncomeResponse;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author
 * @version FuiouMerchantIncomeRequest.java, v 0.1 2023-09-16 09:32:01
 */
@Data
public class FuiouMerchantIncomeRequest extends FuiouBizRequest<FuiouMerchantIncomeResponse, FuiouMerchantApiDefinitionEnum> implements Serializable {

    private static final long serialVersionUID = -2213838555820211610L;


    /**
     * 唯一流水号，机构自己定义，此字段可辅助拉取报文
     * (必填)
     */
    @NotBlank
    private String traceNo;

    /**
     * 二级代理机构号(若无二级代理或不知此字段意思可直接不传
     * (选填)
     */
    private String subInsCd;

    /**
     * 商户全称，不能有特殊字符，仅可包含汉字、数字、字母 (需与营业执照一致，如遇提示重复，请在后面加数字1、2...，若为小微商户，请命名为 商户 xxx。)
     * (必填)
     */
    @NotBlank
    private String mchntName;

    /**
     * 商户简称，不能有特殊字符，仅可包含汉字、数字、字母 (建议和商户门头名称保持一致)
     * (必填)
     */
    @NotBlank
    private String mchntShortname;

    /**
     * 挂靠商户号
     * (选填)
     */
    private String linkMchntCd;

    /**
     * 商户真实名称(与营业执照上相同,小微商户可以不填)
     * (必填)
     */
    private String realName;

    /**
     * 证件类型： 0 企业商户：营业执照（license_no填15位长的营业执照编号） 1 企业商户：三证合一（license_no填18位长的三证合一营业执照编号） A 小微商户：身份证(一证下机) B 个体户工商户（个体工商户不论证件是营业执照还是三证合一都传 B） 2 事业单位
     * (必填)
     */
    @NotBlank
    private String licenseType;

    /**
     * 证件号码，填写方法： 1.license_type=0 或 1 或 2，此处填写营业执照号码。 2.license_type=A，此处填写身份证号码 3.license_type=B，此处填写个体工商户营业执照号码
     * (必填)
     */
    @NotBlank
    private String licenseNo;

    /**
     * 证件到期日（格式yyyyMMdd） 长期请填20991231，无有效期请填19000101 1.license_type=0 或 1 或 2，此处填写营业执照到期日。 2.license_type=A，此处填写身份证的到期日 3.license_type=B，此处填写个体工商户营业执照号的到期日
     * (必填)
     */
    @NotBlank
    private String licenseExpireDt;

    /**
     * 法人身份证号
     * (必填)
     */
    @NotBlank
    private String certifId;

    /**
     * 法人身份证到期日（格式 YYYYMMDD）长期请填20991231(法人年龄超过46岁填写)
     * (必填)
     */
    @NotBlank
    private String certifIdExpireDt;

    /**
     * 联系人姓名（不能有特殊字符）
     * (必填)
     */
    @NotBlank
    private String contactPerson;

    /**
     * 客服电话，必须纯数字。推荐 400开头电话或11位有效手机号
     * (必填)
     */
    @NotBlank
    private String contactPhone;

    /**
     * 商户经营地联系地址
     * (必填)
     */
    @NotBlank
    private String contactAddr;

    /**
     * 联系电话
     * (必填)
     */
    @NotBlank
    private String contactMobile;

    /**
     * 联系邮箱
     * (必填)
     */
    @NotBlank
    private String contactEmail;

    /**
     * 经营范围代码（新开户则必填） 见附件4.微信经营范围代码
     * (必填)
     */
    @NotBlank
    private String business;

    /**
     * 商户经营地市代码 见附件6.省市区代码对照表
     * (必填)
     */
    @NotBlank
    private String cityCd;

    /**
     * 商户经营地区县代码（必须属于 city_cd 所辖） 见附件6.省市区代码对照表
     * (必填)
     */
    @NotBlank
    private String countyCd;

    /**
     * 入账卡类型：1：对公；2：对私; 入账卡类型为 1 时，对公户户名需与营业执照名称保持一致（进件若为双账户时，此处必填 2 ，即对私结算）
     * (必填)
     */
    @NotBlank
    private String acntType;

    /**
     * 行别,（acnt_type=1 必填）(参考行别对照表) 见附件7.行别对照表
     * (选填)
     */
    private String bankType;

    /**
     * 入账卡开户行联行号 对公户和城商行，农商行，农信社必填，否则影响银行卡入账。 如果联行号在富友给的表格里不存在，可联系运营人员添加 见附件9.开户行信息列表
     * (必填)
     */
    @NotBlank
    private String interBankNo;

    /**
     * 入账卡开户行名称 见附件9.开户行信息列表
     * (必填)
     */
    @NotBlank
    private String issBankNm;

    /**
     * 入账卡户名 1. 如果 license_type=A，acnt_nm=artif_nm 即小微商户身份证入网须入账法人 2. 如果 acnt_type=2 且acnt_artif_flag=1，则 acnt_nm=artif_nm 即对私且法人入账，则入账卡户名和法人姓名一致 3. 如果 acnt_type=1 且acnt_artif_flag=1，则 acnt_nm=real_name 即对公且法人入账，则入账卡户名和营业执照上商户名一致(营业执照上商户名指的是店铺名称)
     * (必填)
     */
    @NotBlank
    private String acntNm;

    /**
     * 入账卡号（不带长度位）
     * (必填)
     */
    @NotBlank
    private String acntNo;

    /**
     * 清算类型： 1 自动结算（T1）； 2 手动结算； 3 自动结算（D1）； 4 定时结算 1：T+1 自动结算商户款项 2：需商户手动提现才能将款项入账到银行卡
     * (必填)
     */
    @NotBlank
    private String settleTp;

    /**
     * 法人姓名 （如果 acnt_type=2 且acnt_artif_flag=1，则 acnt_nm=artif_nm 即对私且法人入账，则入账卡户名和法人姓名一致）
     * (必填)
     */
    @NotBlank
    private String artifNm;

    /**
     * 法人入账标识 0 :非法人入账，1：法人入账 若license_type=A，这此字段必须填：1：法人入账
     * (必填)
     */
    @NotBlank
    private String acntArtifFlag;

    /**
     * 入账证件类型("0":"身份证"【默认】)
     * 0：身份证
     * 1：护照
     * 3：警察证
     * 5：通行证
     * 8：台胞证
     * A：港澳居民居住证
     * B：台湾居民居住证
     * C：外国人永久居留身份证
     * (必填)
     */
    private String acntCertifTp;

    /**
     * 入账证件号 【acnt_artif_flag = 0时必填】 1.如果 license_type=A，则acnt_certif_id =license_no 即小微商户身份证入网须入账人身份证号码即法人身份证号码 2.如果 acnt_type=2 且acnt_artif_flag=1，则acnt_certif_id =certif_id 即对私且法人入账，则入账卡人身份证号码和法人身份证号码一致
     * (必填)
     */
    private String acntCertifId;

    /**
     * 入账证件到期日（格式 yyyyMMdd） license_type=A，这里的值acnt_certif_expire_dt=license_expire_dt
     * (必填)
     */
    private String acntCertifExpireDt;

    /**
     * 对私户入账手机号
     * (选填)
     */
    private String acntContactMobile;

    /**
     * 退货标识(0：不能退货，1：可以退货)(此字段已废弃)
     * (选填)
     */
    private String thFlag;

    /**
     * 微信业务标识(0：微信一般类) 如需开通绿洲，请平台申请
     * (选填)
     */
    private String wxBusiFlag;

    /**
     * 微信支付标识（0：不开通，1：开通【默认】）
     * (选填)
     */
    private String wxFlag;

    /**
     * 微信扣率套餐代码(如果wx_flag=1，则必填) 见附件1.扣率套餐代码
     * (选填)
     */
    private String wxSetCd;

    /**
     * 支付宝支付标识（0：不开通，1：开通【默认】）
     * (选填)
     */
    private String aliFlag;

    /**
     * 支付宝扣率套餐代码(如果ali_flag=1，则必填) 见附件1.扣率套餐代码
     * (选填)
     */
    private String aliSetCd;

    /**
     * QQ钱包支付标识（0：不开通【默认】，1：开通）
     * (选填)
     */
    private String qpayFlag;

    /**
     * QQ钱包扣率套餐代码 若此字段不填，则取wx_set_cd值作为QQ扣率套餐代码
     * (选填)
     */
    private String qpaySetCd;

    /**
     * JD钱包支付标识（0：不开通【默认】，1：开通）
     * (选填)
     */
    private String jdpayFlag;

    /**
     * JD钱包扣率套餐代码 若此字段不填，则取wx_set_cd值作为JD扣率套餐代码
     * (选填)
     */
    private String jdpaySetCd;

    /**
     * 天天结 D1 标识（0：不开通【默认】，1：开通） (此字段已废弃，请使用 settle_tp 字段(值为 3))
     * (选填)
     */
    private String dailySettleFlag;

    /**
     * 天天结 D1 扣率套餐代码 （daily_settle_flag ==1 时必填） (此字段已废弃，请使用settle_tp_cd 字段)(使用d0扣率模板)
     * (选填)
     */
    private String dailySettleSetCd;

    /**
     * 清算类型扣率套餐代码(settle_tp==3或者settle_tp==4时必填) (使用d0扣率模板见附件1.扣率套餐代码)
     * (选填)
     */
    private String settleTpCd;

    /**
     * 清算时间，08-23定时清算时间 (settle_tp==4 时必填) 建议清算时间设置为09点以后
     * (选填)
     */
    private String settleTs;

    /**
     * 是否有备用对公银行账号(1：有，0：没有) reserve_acnt 相关字段用于传双账户对公卡信息 注：双账户（指企业户对私结算）此处必须填上企业对公户 此备用账号单纯做信息留存用，不会作为入账卡，交易结算不会入账到备用卡
     * (选填)
     */
    private String hasReserveAcnt;

    /**
     * 双账户对公卡卡号
     * (选填)
     */
    private String reserveAcntNo;

    /**
     * 双账户对公卡户名
     * (选填)
     */
    private String reserveAcntNm;

    /**
     * 双账户对公卡联行号 见附件9.开户行信息列表 如果联行号在富友给的表格里不存在，可联系运营人员添加
     * (选填)
     */
    private String reserveInterBankNo;

    /**
     * 双账户对公卡开户行名称 见附件9.开户行信息列表
     * (选填)
     */
    private String reserveIssBankNm;

    /**
     * 双账户对公卡行别 见附件7.行别对照表
     * (选填)
     */
    private String reserveBankType;

    /**
     * 联系人身份证号(9月10日后必填)
     * (选填)
     */
    private String contactCertNo;

    /**
     * 营业执照开始时间 无有效期请填19000101(当证件类型为0，1，2，B时必填(2021年9月10日后必填))
     * (选填)
     */
    private String licenseStartDt;

    /**
     * 营业执照注册地址 (当证件类型为0，1，2，B时必填(2021年9月10日后必填))
     * (选填)
     */
    private String licRegisAddr;

    /**
     * 法人身份证开始时间(2021年9月10日后必填)
     * (选填)
     */
    private String cardStartDt;

    /**
     * 业务员编号
     * (选填)
     */
    private String salesMan;

    /**
     * 所属银行
     * (选填)
     */
    private String connInsCd;

    /**
     * 客户经理
     * (选填)
     */
    private String customerManage;

    /**
     * 支付宝MCC
     * (选填)
     */
    private String aliMcc;

    /**
     * 法人手机号
     * (必填)
     */
    @NotBlank
    private String certifPhone;

    /**
     * 法人身份证地址
     * (必填)
     */
    private String certifAddr;

    /**
     * 法人证件类型：
     * 0：身份证
     * 1：护照
     * 2：港澳居民来往内地通行证
     * 4：台湾居民来往大陆通行证
     * 5：港澳居民居住证
     * 6：台湾居民居住证
     * 7：外国人永久居留身份证
     * 9：其他
     */
    private String artifTp;
}