/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.fuiou.client.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.fshows.fuiou.client.base.ApiClientConfig;
import com.fshows.fuiou.client.base.FuiouHttpResult;
import com.fshows.fuiou.client.base.IHttpRequest;
import com.fshows.fuiou.util.FsHttpUtil;
import org.xml.sax.SAXException;

import javax.xml.parsers.ParserConfigurationException;
import java.io.IOException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * http请求实现类
 *
 * @author liluqing
 * @version DefaultHttpRequest.java, v 0.1 2022-03-02 18:19
 */
public class DefaultHttpRequestImpl implements IHttpRequest {

    @Override
    public FuiouHttpResult post(String url, String authorization, String requestBody, ApiClientConfig apiClientConfig) throws Exception {
        Map<String, String> headers = new HashMap<>();
        // headers.put("Authorization", authorization);

        Map<String, String> param = new HashMap<>();
        param.put("req", URLEncoder.encode(requestBody, apiClientConfig.getCharset()));
        String fsHttpResult = FsHttpUtil.post(
                url,
                param,
                apiClientConfig.getCharset(),
                null,
                apiClientConfig.getConnectionTimeout(),
                apiClientConfig.getReadTimeout(),
                headers);
        if (fsHttpResult != null) {
            return convertFuiouHttpResult(fsHttpResult, apiClientConfig);
        }
        return null;
    }


    /**
     * fsHttpResult 转>> FuiouHttpResult
     *
     * @param response        响应
     * @param apiClientConfig API客户端配置
     * @return {@link FuiouHttpResult}
     * @throws ParserConfigurationException 解析器配置异常
     * @throws IOException                  ioexception
     * @throws SAXException                 saxexception
     */
    private FuiouHttpResult convertFuiouHttpResult(String response, ApiClientConfig apiClientConfig) throws ParserConfigurationException, IOException, SAXException {
        FuiouHttpResult fuiouHttpResult = new FuiouHttpResult();
        fuiouHttpResult.setBody(URLDecoder.decode(response, apiClientConfig.getCharset()));
        return fuiouHttpResult;
    }

    /**
     * 从headList中获取具体某个key值
     *
     * @param key
     * @param headList
     * @return
     */
    private String getHeadFeild(String key, Map<String, List<String>> headList) {
        if (headList == null) {
            return null;
        }
        List<String> valueList = headList.get(key);
        if (CollectionUtil.isEmpty(valueList)) {
            return null;
        }
        return valueList.get(0);
    }
}