/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fuiou.client.impl;

import cn.hutool.core.util.RandomUtil;
import com.alibaba.fastjson.JSONObject;
import com.fshows.fuiou.client.base.ApiClientConfig;
import com.fshows.fuiou.client.base.IFuiouApiDefinition;
import com.fshows.fuiou.client.base.IHttpRequest;
import com.fshows.fuiou.client.base.ISigner;
import com.fshows.fuiou.client.base.SignParam;
import com.fshows.fuiou.client.impl.AbstractFuiouApiClientImpl;
import com.fshows.fuiou.client.impl.DefaultHttpRequestImpl;
import com.fshows.fuiou.client.impl.MerchantSignerImpl;
import com.fshows.fuiou.exception.FuiouApiException;
import com.fshows.fuiou.request.base.FuiouBizRequest;
import com.fshows.fuiou.response.base.FuiouBizResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MerchantFuiouApiJsonClientImpl
extends AbstractFuiouApiClientImpl {
    private static final Logger log = LoggerFactory.getLogger(MerchantFuiouApiJsonClientImpl.class);

    public MerchantFuiouApiJsonClientImpl(ApiClientConfig apiClientConfig) throws FuiouApiException {
        super(apiClientConfig, new DefaultHttpRequestImpl(), new MerchantSignerImpl());
    }

    public MerchantFuiouApiJsonClientImpl(ApiClientConfig apiClientConfig, IHttpRequest httpRequest, ISigner signer) throws FuiouApiException {
        super(apiClientConfig, httpRequest, signer);
    }

    @Override
    public <T extends FuiouBizResponse, R extends IFuiouApiDefinition> T execute(FuiouBizRequest<T, R> request, R merchantApiDefinitionEnum) throws FuiouApiException {
        return (T)super.doExecute(request, merchantApiDefinitionEnum);
    }

    @Override
    protected FuiouBizRequest buildFuiouBizRequest(FuiouBizRequest request, IFuiouApiDefinition merchantApiDefinitionEnum) {
        request.setInsCd(this.apiClientConfig.getAppId());
        return request;
    }

    @Override
    protected SignParam buildSignParam(FuiouBizRequest baseRequest) {
        SignParam signParam = new SignParam();
        signParam.setAppid(this.apiClientConfig.getAppId());
        signParam.setNonceStr(RandomUtil.randomString((int)12));
        signParam.setRequest(baseRequest);
        return signParam;
    }

    @Override
    protected String serializableRequest(FuiouBizRequest fuiouBaseRequest, String sign, IFuiouApiDefinition merchantApiDefinitionEnum) {
        return JSONObject.toJSONString((Object)fuiouBaseRequest);
    }

    @Override
    protected FuiouBizResponse parseResponse(String body, IFuiouApiDefinition merchantApiDefinitionEnum) {
        return (FuiouBizResponse)JSONObject.parseObject((String)body, merchantApiDefinitionEnum.getResponseClass());
    }
}

