/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.steward.component;

import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.URLUtil;
import cn.hutool.core.util.XmlUtil;
import com.alibaba.fastjson.JSON;
import com.fshows.fuiou.util.FuiouRequestUtils;
import com.fshows.fuiou.util.LogUtil;
import com.fshows.fuiou.util.RsaUtils;
import com.fshows.fuiou.util.XmlConvertUtil;
import com.fshows.sdk.core.client.base.definition.IResponseDefinition;
import com.fshows.sdk.core.client.base.handler.ISerializableHandler;
import com.fshows.sdk.core.client.base.model.ApiRequestModel;
import com.fshows.sdk.core.client.base.model.ApiResponseModel;
import com.fshows.sdk.core.client.base.model.DefaultClientConfigModel;
import com.fshows.sdk.core.client.base.model.DefaultRequestContext;
import com.fshows.sdk.core.exception.FsApiException;
import com.fshows.steward.apienum.FuStewardApiDefinitionEnum;
import com.fshows.steward.enums.FuStewardApiTypeEnum;
import com.fshows.steward.request.FuStewardBaseRequest;
import com.fshows.steward.response.FuStewardBaseResponse;
import com.fshows.steward.response.FuStewardBizResponse;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FuStewardSerializableHandler
implements ISerializableHandler {
    private static final Logger log = LoggerFactory.getLogger(FuStewardSerializableHandler.class);

    public String serializeObject(ApiRequestModel apiRequestModel, DefaultRequestContext requestContext) {
        if (!(requestContext.getIApiDefinition() instanceof FuStewardApiDefinitionEnum)) {
            throw new FsApiException("\u53c2\u6570\u5e8f\u5217\u5316\u5931\u8d25");
        }
        FuStewardApiDefinitionEnum apiDefinitionEnum = (FuStewardApiDefinitionEnum)requestContext.getIApiDefinition();
        if (FuStewardApiTypeEnum.ENCRYPT_API.equals((Object)apiDefinitionEnum.getApiTypeEnum())) {
            return this.encryptApiSerializeObject(apiRequestModel, requestContext);
        }
        return this.normalApiSerializeObject(apiRequestModel, requestContext);
    }

    private String normalApiSerializeObject(ApiRequestModel apiRequestModel, DefaultRequestContext requestContext) {
        String xmlStr = FuiouRequestUtils.generateXmlByObjectMap(apiRequestModel.getParamMap());
        String enCodeStr = URLUtil.encodeAll((String)xmlStr, (Charset)CharsetUtil.CHARSET_GBK);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("req", enCodeStr);
        apiRequestModel.setRequestForm(params);
        return enCodeStr;
    }

    private String encryptApiSerializeObject(ApiRequestModel apiRequestModel, DefaultRequestContext requestContext) {
        FuStewardBaseRequest request = (FuStewardBaseRequest)apiRequestModel.getRequest();
        DefaultClientConfigModel apiClientConfig = requestContext.getApiClientConfig();
        String xmlStr = FuiouRequestUtils.generateXmlByObjectMap(apiRequestModel.getParamMap());
        String encrypt = RsaUtils.encrypt(xmlStr, apiClientConfig.getPayCompanyPublicKey());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("mchntCd", request.getMchntCd());
        params.put("message", encrypt);
        return JSON.toJSONString(params);
    }

    public IResponseDefinition deserializationResponse(ApiResponseModel apiResponseModel, ApiRequestModel apiRequestModel, DefaultRequestContext requestContext) {
        if (!(requestContext.getIApiDefinition() instanceof FuStewardApiDefinitionEnum)) {
            throw new FsApiException("\u53c2\u6570\u5e8f\u5217\u5316\u5931\u8d25");
        }
        FuStewardApiDefinitionEnum apiDefinitionEnum = (FuStewardApiDefinitionEnum)requestContext.getIApiDefinition();
        if (FuStewardApiTypeEnum.ENCRYPT_API.equals((Object)apiDefinitionEnum.getApiTypeEnum())) {
            return this.encryptApiDeserializationResponse(apiResponseModel, apiRequestModel, requestContext);
        }
        return this.normalApiDeserializationResponse(apiResponseModel, apiRequestModel, requestContext);
    }

    private IResponseDefinition normalApiDeserializationResponse(ApiResponseModel apiResponseModel, ApiRequestModel apiRequestModel, DefaultRequestContext requestContext) {
        try {
            FuStewardBaseResponse baseResponse = new FuStewardBaseResponse();
            String deCodeStr = URLUtil.decode((String)apiResponseModel.getResponseBody(), (String)"GBK");
            FuStewardBizResponse bizResponse = (FuStewardBizResponse)XmlConvertUtil.xml2Bean(deCodeStr, requestContext.getIApiDefinition().getResponseClass());
            baseResponse.setData(bizResponse);
            baseResponse.setMchntCd(bizResponse.getMchntCd());
            apiResponseModel.setResponseSign(bizResponse.getSignature());
            apiResponseModel.setResponseMap(FuiouRequestUtils.ObjectToMap(bizResponse));
            return baseResponse;
        }
        catch (Exception e) {
            LogUtil.error(log, "\u3010fuiou-sdk-fusteward\u3011\u54cd\u5e94\u7ed3\u679c\u53cd\u5e8f\u5217\u5316\u5f02\u5e38 >> resBody={}", e, apiResponseModel.getResponseBody());
            throw new FsApiException("[fuiou-sdk-fusteward]\u54cd\u5e94\u7ed3\u679c\u53cd\u5e8f\u5217\u5316\u5f02\u5e38");
        }
    }

    public static void main(String[] args) {
        String xml = "<xml>\n    <respCode>0000</respCode>\n    <respDesc>\u4ea4\u6613\u6210\u529f</respDesc>\n    <signature>GmS7HYeXB9zH4vVRvIOPAUyzlumiobm/DjJFDOGmyeXkeEV3bERyz2kmDxjBDxg87uMlcB563DQ3aO8it1W9LCBoRF7ZT5dayZawxe3vK5PXuYNcYzvmQGExKoqD6tira4wpwKN76OnSF9FXllOQvOU11Rv7vV9LAtsJ7DTjQoA=</signature>\n    <mchntCd>0002900F0370542</mchntCd>\n    <traceNo>2024011016220123448094</traceNo>\n    <items>\n        <items>\n            <mchntCdConcentrate>0002900F0096235</mchntCdConcentrate>\n            <batchNo>847d8e1ee33544a582a57ea0b767bd70</batchNo>\n            <orderConcentrateScale>10000</orderConcentrateScale>\n            <balanceConcentrateScale>10000</balanceConcentrateScale>\n            <concentrateTypes>\n                <concentrateTypes>01</concentrateTypes>\n                <concentrateTypes>02</concentrateTypes>\n                <concentrateTypes>03</concentrateTypes>\n                <concentrateTypes>04</concentrateTypes>\n            </concentrateTypes>\n            <useType>01</useType>\n            <status>00</status>\n            <createDate>2024-01-10 15:54:26</createDate>\n            <startDate/>\n            <endDate/>\n        </items>\n        <items>\n            <mchntCdConcentrate>0002900F0096235</mchntCdConcentrate>\n            <batchNo>847d8e1ee33544a582a57ea0b767bd70</batchNo>\n            <orderConcentrateScale>10000</orderConcentrateScale>\n            <balanceConcentrateScale>10000</balanceConcentrateScale>\n            <concentrateTypes>\n                <concentrateTypes>01</concentrateTypes>\n                <concentrateTypes>02</concentrateTypes>\n                <concentrateTypes>03</concentrateTypes>\n                <concentrateTypes>04</concentrateTypes>\n            </concentrateTypes>\n            <useType>01</useType>\n            <status>00</status>\n            <createDate>2024-01-10 15:54:26</createDate>\n            <startDate/>\n            <endDate/>\n        </items>\n    </items>\n</xml>";
        Map resMap = XmlUtil.xmlToMap((String)xml);
        System.out.println(resMap);
    }

    private IResponseDefinition encryptApiDeserializationResponse(ApiResponseModel apiResponseModel, ApiRequestModel apiRequestModel, DefaultRequestContext requestContext) {
        FuStewardBaseResponse baseResponse = new FuStewardBaseResponse();
        DefaultClientConfigModel configModel = requestContext.getApiClientConfig();
        Map resMap = null;
        try {
            resMap = XmlUtil.xmlToMap((String)apiResponseModel.getResponseBody());
        }
        catch (Exception e) {
            LogUtil.error(log, "\u3010fuiou-sdk-fusteward\u3011\u54cd\u5e94\u7ed3\u679c\u53cd\u5e8f\u5217\u5316\u5f02\u5e38 >> resBody={}", e, apiResponseModel.getResponseBody());
            throw new FsApiException("[fuiou-sdk-fusteward]\u54cd\u5e94\u7ed3\u679c\u53cd\u5e8f\u5217\u5316\u5f02\u5e38");
        }
        String mchntCd = resMap.get("mchntCd").toString();
        baseResponse.setMchntCd(mchntCd);
        String message = resMap.get("message").toString();
        String encrypt = RsaUtils.decrypt(message, configModel.getFubeiPrivateKey());
        Map<String, String> bizMap = null;
        try {
            bizMap = FuiouRequestUtils.getMapFromXML(encrypt);
        }
        catch (Exception e) {
            LogUtil.error(log, "\u3010fuiou-sdk-fusteward\u3011\u54cd\u5e94\u7ed3\u679c\u53cd\u5e8f\u5217\u5316\u5f02\u5e38 >> resBody={}", e, encrypt);
            throw new FsApiException("[fuiou-sdk-fusteward]\u54cd\u5e94\u7ed3\u679c\u53cd\u5e8f\u5217\u5316\u5f02\u5e38");
        }
        FuStewardBizResponse bizResponse = (FuStewardBizResponse)FuiouRequestUtils.mapToObject(resMap, requestContext.getIApiDefinition().getResponseClass());
        String signature = bizMap.remove("signature");
        apiResponseModel.setResponseSign(signature);
        baseResponse.setData(bizResponse);
        return baseResponse;
    }
}

