/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.frt.fubeiopenapisdk.response.merchant;

import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.annotation.JSONType;
import com.frt.fubeiopenapisdk.response.FubeiBizResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author zhoujp
 * @version WechatAuthStatusQueryResult.java, v 0.1 2020-12-22 16:08 zhoujp
 */
@Data
@JSONType(naming = PropertyNamingStrategy.SnakeCase)
@EqualsAndHashCode(callSuper = true)
public class FubeiMerchantWechatAuthApplyQueryResponse extends FubeiBizResponse {
    private static final long serialVersionUID = -2209075303694172758L;

    /**
     * 枚举值说明：
     * APPLYMENT_STATE_WAITTING_FOR_AUDIT：【审核中】，请耐心等待1~2个工作日，微信支付将会完成审核。
     * APPLYMENT_STATE_EDITTING：【编辑中】，可能提交申请发生了错误导致，可用同一个业务申请编号重新提交。
     * APPLYMENT_STATE_WAITTING_FOR_CONFIRM_CONTACT：【待确认联系信息】，请扫描微信支付返回的小程序码确认联系信息(此过程可修改超级管理员手机号)。
     * APPLYMENT_STATE_WAITTING_FOR_CONFIRM_LEGALPERSON：【待账户验证】，请扫描微信支付返回的小程序码在小程序端完成账户验证。
     * APPLYMENT_STATE_PASSED：【审核通过】，请扫描微信支付返回的小程序码在小程序端完成授权流程。
     * APPLYMENT_STATE_REJECTED：【审核驳回】，请按照驳回原因修改申请资料，并更换业务申请编码，重新提交申请。
     * APPLYMENT_STATE_FREEZED：【已冻结】，可能是该主体已完成过入驻，请查看驳回原因，并通知驳回原因中指定的联系人扫描微信支付返回的小程序码在小程序端完成授权流程。
     * 8、APPLYMENT_STATE_CANCELED：【已作废】，表示申请单已被撤销，无需再对其进行操作。
     * 示例值：APPLYMENT_STATE_PASSED
     */
    private String applymentState;

    /**
     * 1、当申请单状态为APPLYMENT_STATE_WAITTING_FOR_CONFIRM_CONTACT、APPLYMENT_STATE_WAITTING_FOR_CONFIRM_LEGALPERSON、APPLYMENT_STATE_PASSED、APPLYMENT_STATE_FREEZED时，会返回小程序码图片。
     * 2、使用base64解码该字段，可得到图片二进制数据。
     * 3、可用img标签直接加载该图片。示例如下：
     * <img src="data:image/png;base64,iVBORw0KGgoAAAANSU=" style="display: block;">
     * 示例值: cGFnZXMvYXBwbHkvYXBpdzQvd2VsY29tZS93ZWxjb21lP2FwcGx5bWVudF9pZD14eHg=
     */
    private String qrcodeData;

    /**
     * 当申请单状态为“审核驳回”时，会返回该字段，标识被驳回的字段名。
     * 示例值：merchant_name
     */
    private String rejectParam;

    /**
     * 当申请单状态为“审核驳回”时，会返回该字段，表示驳回原因。
     * 示例值：公司名称与工商局登记不一致
     */
    private String rejectReason;

    /**
     * 申请单编号和业务申请编号至少传一个。
     */
    private String applymentId;

    /**
     * 1、服务商自定义的唯一编号。
     * 2、每个编号对应一个申请单。
     */
    private String businessCode;
}