package com.frt.fubeiopenapisdk.response.merchant;

import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.annotation.JSONType;
import com.frt.fubeiopenapisdk.response.FubeiBizResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;


@Data
@EqualsAndHashCode(callSuper = true)
@JSONType(naming = PropertyNamingStrategy.SnakeCase)
public class FubeiMerchantSignResponse extends FubeiBizResponse {

    /**
     * 付呗商户ID
     */
    private Integer merchantId;
    /**
     * 商户账号，外部系统的唯一商户编号（可以用作登录付呗商户后台）
     */
    private String merchantCode;
    /**
     * 协议类型LICENSE入网协议（只有拉卡拉，易生）CERTIFICATE非法人结算授权
     */
    private String protocolType;
    /**
     * 协议链接
     */
    private String contractUrl;

}
