/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.frt.fubeiopenapisdk.response.merchant;

import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.annotation.JSONType;
import com.frt.fubeiopenapisdk.response.FubeiBizResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author zhoujp
 * @version WechatAuthStatusQueryResult.java, v 0.1 2020-12-22 16:08 zhoujp
 */
@Data
@EqualsAndHashCode(callSuper = true)
@JSONType(naming = PropertyNamingStrategy.SnakeCase)
public class FubeiMerchantAlipayAuthApplyQueryResponse extends FubeiBizResponse {
    private static final long serialVersionUID = -2209075303694172758L;

    /**
     * 支付宝返回状态：
     * 审核zhong (AUDITING)、
     * 待联系人确认（CONTACT_CONFIRM）、
     * 待法人确认（LEGAL_CONFIRM）、
     * 审核通过(AUDIT_PASS)、
     * 审核失败(AUDIT_REJECT)、
     * 已冻结(AUDIT_FREEZE)、
     * 已撤回(CANCELED)
     */
    private String applymentState;

    /**
     * 1、当申请单状态为APPLYMENT_STATE_WAITTING_FOR_CONFIRM_CONTACT、APPLYMENT_STATE_WAITTING_FOR_CONFIRM_LEGALPERSON、APPLYMENT_STATE_PASSED、APPLYMENT_STATE_FREEZED时，会返回小程序码图片。
     * 2、使用base64解码该字段，可得到图片二进制数据。
     * 3、可用img标签直接加载该图片。示例如下：
     * <img src="data:image/png;base64,iVBORw0KGgoAAAANSU=" style="display: block;">
     * 示例值: cGFnZXMvYXBwbHkvYXBpdzQvd2VsY29tZS93ZWxjb21lP2FwcGx5bWVudF9pZD14eHg=
     */
    private String qrcodeData;

    /**
     * 当申请单状态为“审核驳回”时，会返回该字段，标识被驳回的字段名。
     * 示例值：merchant_name
     */
    private String rejectParam;

    /**
     * 当申请单状态为“审核驳回”时，会返回该字段，表示驳回原因。
     * 示例值：公司名称与工商局登记不一致
     */
    private String rejectReason;

    /**
     * 申请单编号和业务申请编号至少传一个。
     */
    private String applymentId;

    /**
     * 1、服务商自定义的唯一编号。
     * 2、每个编号对应一个申请单。
     */
    private String businessCode;
}