/**
 * fshows.com
 * Copyright (C) 2013-2019 All Rights Reserved.
 */
package com.frt.fubeiopenapisdk.response.account;

import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.annotation.JSONType;
import com.frt.fubeiopenapisdk.response.FubeiBizResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author zhoujp
 * @version SubAccountReceiveQueryResult.java, v 0.1 2019-11-07 20:41 zhoujp
 */
@Data
@EqualsAndHashCode(callSuper = true)
@JSONType(naming = PropertyNamingStrategy.SnakeCase)
public class FubeiSubAccountReceiveQueryResponse extends FubeiBizResponse {
    private static final long serialVersionUID = 3192655574851098949L;

    /**
     * 请求流水号
     */
    private String merchantOrderSn;

    /**
     * 分账接收方id
     */
    private String accountId;

    /**
     * 1：入驻成功 2：入驻中 3：入驻失败
     */
    private Integer incomeStatus;

    /**
     * 失败原因
     */
    private String failMessage;

    /**
     * 客户名称
     */
    private String account;

    /**
     * 客户类型：1 企业 2 个体
     */
    private Integer bussinessType;

    /**
     * 营业执照号
     */
    private String licenseNo;

    /**
     * 营业执照有效期开始时间，格式为yyyyMMdd
     */
    private String licenseTimeBegin;

    /**
     * 营业执照有效期结束时间，格式为yyyyMMdd，若永久则不传
     */
    private String licenseTimeEnd;

    /**
     * 法人姓名，企业填营业执照上的法人姓名；个体工商户填持卡人姓名。
     */
    private String legalPersonName;

    /**
     * 法人证件类型
     */
    private String legalPersonIdCardType;

    /**
     * 法人证件号
     */
    private String legalPersonIdCardNo;

    /**
     * 结算人证件类型
     */
    private String idCardType;

    /**
     * 结算人证件号
     */
    private String idCardNo;

    /**
     * 结算账户类型
     */
    private Integer accountType;

    /**
     * 结算银行卡号
     */
    private String accountNo;

    /**
     * 结算银行开户名
     */
    private String accountName;

    /**
     * 开户总行
     */
    private String bankName;

    /**
     * 开户支行
     */
    private String branchName;

    /**
     * 联行号
     */
    private String bankNo;

    /**
     * 预留手机号
     */
    private String bankCellPhone;

    /**
     * 品类id
     */
    private Integer unityCategoryId;

}