/*
 * ailike.com
 * Copyright (C) 2022-2025 All Rights Reserved.
 */
package com.frt.fubeiopenapisdk.response.account;

import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.annotation.JSONType;
import com.frt.fubeiopenapisdk.response.FubeiBizResponse;
import com.frt.fubeiopenapisdk.response.account.detail.AccountFixQueryDataResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @author zhangling
 * @version FubeiAccountFixAmountResponse.java, v 0.1 2025-11-04 10:08 zhangling
 */
@Data
@EqualsAndHashCode(callSuper = true)
@JSONType(naming = PropertyNamingStrategy.SnakeCase)
public class FubeiAccountFixQueryResponse extends FubeiBizResponse {
    private static final long serialVersionUID = 8539057775163382394L;
    /**
     * merchant_id	Integer	是	11	付呗商户号
     * merchant_order_sn	String	是	32	外部系统订单号
     * order_no	String	否	32	付呗分账订单号
     * data_list	Array	是	-	分账账单列表
     */
    /**
     * 付呗商户号
     */
    private String merchantId;
    /**
     * 外部系统订单号
     */
    private String merchantOrderSn;
    /**
     * 付呗分账订单号
     */
    private String orderNo;
    /**
     * 分账账单列表
     */
    private List<AccountFixQueryDataResponse> dataList;
}