/*
 * ailike.com
 * Copyright (C) 2022-2025 All Rights Reserved.
 */
package com.frt.fubeiopenapisdk.response.account;

import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.annotation.JSONType;
import com.frt.fubeiopenapisdk.response.FubeiBizResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * @author zhangling
 * @version FubeiAccountBalanceQueryResponse.java, v 0.1 2025-11-04 09:26 zhangling
 */
@Data
@EqualsAndHashCode(callSuper = true)
@JSONType(naming = PropertyNamingStrategy.SnakeCase)
public class FubeiAccountBalanceQueryResponse extends FubeiBizResponse {
    private static final long serialVersionUID = -222716615027441253L;
    /**
     * 付呗商户号，查询时传入则返回
     */
    private Integer merchantId;
    /**
     * 分账接收方id，查询时传入则返回
     */
    private String accountId;
    /**
     * 今日余额（元），精确到0.01。查询分账接收方时该字段为0
     */
    private BigDecimal clearingAmount;
    /**
     * 可提金额（元），精确到0.01
     */
    private BigDecimal settledAmount;
    /**
     * 冻结金额（元），精确到0.01（若存在风险交易、入账异常等情况时，会造成金额被冻结，请联系客服）
     */
    private BigDecimal frozenAmount;
    /**
     * 分账冻结金额（元），精确到0.01。开启分账功能的商户，在结算时间会将清算金额转入到分账冻结金额，等待分账成功后进入结算金额。
     */
    private BigDecimal shareFrozenAmount;
    /**
     * 可分账金额（元），精确到0.01。分账冻结金额可以用于分账给接收方的金额。计算公式：每日分账冻结金额*分账比例，进行累计
     */
    private BigDecimal allowShareAmount;
    /**
     * 总余额（元），精确到0.01
     */
    private BigDecimal totalAmount;
}