package com.frt.fubeiopenapisdk.request.trade;

import com.alibaba.fastjson.annotation.JSONField;
import com.frt.fubeiopenapisdk.request.FubeiPayBizRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 付呗订单查询请求参数
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class FubeiPayOrderQueryRequest extends FubeiPayBizRequest {

    /**
     * 付呗订单号，和外部系统订单号、机构订单号不能同时为空（三选一），如果同时存在三者优先级为：order_sn>ins_order_sn>merchant_order_sn
     */
    @JSONField(name = "order_sn")
    private String orderSn;
    /**
     * 外部系统订单号，和付呗订单号、机构订单号不能同时为空（三选一）
     */
    @JSONField(name = "merchant_order_sn")
    private String merchantOrderSn;
    /**
     * 机构订单号，和付呗订单号、外部系统订单号不能同时为空（三选一）
     */
    @JSONField(name = "ins_order_sn")
    private String insOrderSn;
    /**
     * 付呗商户号，以服务商级接入时必传，以商户级接入时不传
     */
    @JSONField(name = "merchant_id")
    private String merchantId;
}
