/**
 * fshows.com
 * Copyright (C) 2013-2020 All Right Reserved
 */
package com.frt.fubeiopenapisdk.request.merchant.detail;

import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.annotation.JSONType;
import lombok.Data;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * 其它信息
 *
 * @author buhao
 * @version OtherInfo.java, v 0.1 2021-08-10 15:13 buhao
 */
@Data
@JSONType(naming = PropertyNamingStrategy.SnakeCase)
public class OtherInfoRequest {

    /**
     * 经营许可证图片（请填入上传加密图片
     * 返回的值）
     */
    private String operatingLicensePhoto;

    /**
     * 门店其他照片1
     */
    private String storeOtherPic1;

    /**
     * 门店其他照片2
     */
    private String storeOtherPic2;

    /**
     * 门店其他照片3
     */
    private String storeOtherPic3;

    /**
     * 备注
     */
    private String remark;

    /**
     * 回调地址
     */
    private String callBackUrl;

    /**
     * 平台方组织ID
     */
    private String platformOrgId;
    /**
     * 平台方类型,1万达集团
     */
    private Integer platformType;

    @Override
    public String toString() {
        return ReflectionToStringBuilder.reflectionToString(this,
                ToStringStyle.SHORT_PREFIX_STYLE);
    }

}
