
/**
 * fshows.com
 * Copyright (C) 2013-2020 All Right Reserved
 */
package com.frt.fubeiopenapisdk.request.merchant.detail;

import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.annotation.JSONType;
import lombok.Data;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import java.io.Serializable;

/**
 * 法人信息
 *
 * @author zhaoyi
 * @version legalPerson.java, v 0.1 2020-07-27 12:03 zhaoyi
 */
@Data
@JSONType(naming = PropertyNamingStrategy.SnakeCase)
public class LegalPersonRequest implements Serializable {
    private static final long serialVersionUID = 821079015844156778L;

    /**
     * 法人姓名
     */
    @NotBlank(message = "法人姓名不能为空")
    @Size(min = 2, max = 20, message = "法人姓名超长")
    private String legalName;

    /**
     * 法人证件类型（非必填，不填默认1-身份证）
     * 1-身份证(默认)；
     * 2-香港通行证（回乡证）;
     * 3-台湾身份证；
     * 4-香港身份证；
     * 5-澳门身份证；
     * 6-护照；
     * 7-居住证；
     * 9-其它法定文件;
     * 10-台湾通行证(台胞证);
     * 11-澳门通行证（回乡证）;
     * 12-临时身份证
     */
    @Min(value = 1, message = "法人证件类型不合法")
    @Max(value = 12, message = "法人证件类型不合法")
    private Integer legalIdentityType;

    /**
     * 证件号码
     */
    @NotBlank(message = "证件号码不能为空")
    @Size(max = 18, message = "证件号码超长")
    private String legalNum;

    /**
     * 法人身份证正面图片地址
     */
    @NotBlank(message = "法人身份证正面图片地址不能为空")
    private String legalIdCardFrontPhoto;

    /**
     * 法人身份证反面图片地址
     */
    @NotBlank(message = "法人身份证反面图片地址不能为空")
    private String legalIdCardBackPhoto;

    /**
     * 手持身份证照
     */
    private String handHoldIdCardPhoto;

    /**
     * 证件有效期开始日期
     */
    @NotBlank(message = "证件有效期开始日期不能为空")
    private String legalIdCardStart;

    /**
     * 证件有效期结束日期格式：2015-09-22，永久有效:长期
     */
    @NotBlank(message = "证件有效期结束日期不能为空")
    private String legalIdCardEnd;

    @Override
    public String toString() {
        return ReflectionToStringBuilder.reflectionToString(this,
                ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
