/**
 * fshows.com
 * Copyright (C) 2013-2020 All Right Reserved
 */
package com.frt.fubeiopenapisdk.request.merchant.detail;

import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.annotation.JSONType;
import lombok.Data;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;

/**
 * 联系人信息
 *
 * @author buhao
 * @version ContactInfo.java, v 0.1 2020-07-27 14:30 buhao
 */
@Data
@JSONType(naming = PropertyNamingStrategy.SnakeCase)
public class ContactInfoRequest {
    /**
     * 联系人姓名(与法人一致)
     */
    @NotBlank(message = "联系人姓名不能为空")
    @Size(min = 2, max = 20, message = "联系人姓名超长")
    private String name;

    /**
     * 联系人身份证号
     */
    private String idCardNo;

    /**
     * 手机号码（11位手机号）
     */
    @NotBlank(message = "手机号码不能为空")
    @Size(max = 11, message = "手机号码超长")
    private String mobile;

    @Override
    public String toString() {
        return ReflectionToStringBuilder.reflectionToString(this,
                ToStringStyle.SHORT_PREFIX_STYLE);
    }

}
