/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.frt.fubeiopenapisdk.request.merchant;

import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.annotation.JSONType;
import com.frt.fubeiopenapisdk.request.FubeiBizRequest;
import com.frt.fubeiopenapisdk.request.merchant.detail.AssistInfoRequest;
import com.frt.fubeiopenapisdk.request.merchant.detail.WechatAuthContactInfoRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @author zhoujp
 * @version WechatAuthParam.java, v 0.1 2020-12-22 14:55 zhoujp
 */
@Data
@EqualsAndHashCode(callSuper = true)
@JSONType(naming = PropertyNamingStrategy.SnakeCase)
public class FubeiMerchantWechatAuthApplyRequest extends FubeiBizRequest {
    private static final long serialVersionUID = -1363828382971203857L;

    /**
     * 商户编号
     */
    @NotNull(message = "商户id不能为空")
    private Integer merchantId;

    /**
     * 门店编号
     */
    @NotNull(message = "门店id不能为空")
    private Integer storeId;
    /**
     * 业务申请编号
     */
    @NotBlank(message = "不能为空")
    private String businessCode;

    /**
     * 联系人信息
     */
    private WechatAuthContactInfoRequest contactInfo;

    /**
     * 证件居住地址
     */
    private String identificationAddress;

    /**
     * 单位证明函照片
     * 1、事业单位时必填
     */
    private String companyPic;

    /**
     * 小微商户证明辅助材料
     */
    private AssistInfoRequest assistInfo;
}