/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.frt.fubeiopenapisdk.request.merchant;

import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.annotation.JSONType;
import com.frt.fubeiopenapisdk.request.FubeiBizRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotNull;

/**
 * @author zhoujp
 * @version WechatAuthStatusQueryParam.java, v 0.1 2020-12-22 15:35 zhoujp
 */
@Data
@EqualsAndHashCode(callSuper = true)
@JSONType(naming = PropertyNamingStrategy.SnakeCase)
public class FubeiMerchantWechatAuthApplyCannelRequest extends FubeiBizRequest {
    private static final long serialVersionUID = -5956129215911531920L;

    /**
     * 商户编号
     */
    @NotNull(message = "商户id不能为空")
    private Integer merchantId;
    /**
     * 申请单编号和业务申请编号至少传一个。
     */
    private String applymentId;

    /**
     * 1、服务商自定义的唯一编号。
     * 2、每个编号对应一个申请单。
     */
    private String businessCode;
}