package com.frt.fubeiopenapisdk.request.merchant;

import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.annotation.JSONType;
import com.frt.fubeiopenapisdk.request.FubeiBizRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 付呗批量进件
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class FubeiMerchantBatchEntryRequest extends FubeiBizRequest {

    /**
     * 商户账号
     */
    @JSONField(name = "merchant_name")
    private String merchantName;
    /**
     * 商户平台商编
     */
    @JSONField(name = "merchant_no")
    private String merchantNo;
    /**
     * 代理商编号
     */
    @JSONField(name = "belong")
    private Integer belong;
    /**
     * 授理商编号
     */
    @JSONField(name = "salesman")
    private Integer salesman;
    /**
     * 市场经理编号
     */
    @JSONField(name = "marketId")
    private Integer marketId;
    /**
     * 手机号
     */
    @JSONField(name = "mobile")
    private String mobile;

    /**
     * 门店名称
     */
    @JSONField(name = "store_name")
    private String storeName;

    /**
     * 微信子商户号
     */
    @JSONField(name = "we_chat_sub_mch_id")
    private String weChatSubMchId;
    /**
     * 支付宝子商户号
     */
    @JSONField(name = "alipay_sub_mch_id")
    private String alipaySubMchId;
    /**
     * 银联商户号
     */
    @JSONField(name = "union_code")
    private String unionCode;
    /**
     * 清算类型
     * 15 随行付
     * 21 乐刷
     * 26 联动
     * 34 拉卡拉
     * 43 星富通
     * 47 富友
     * 51 威富通
     * 55 易生
     * 59 华夏
     * 65 国通星驿
     * 68 块钱
     * 71 兴业银行
     * 74 泸州银行
     * 77 福建农信
     * 80 嘉联
     * 83 民生银行
     * 86 银盛
     * 90 中投科信
     */
    @JSONField(name = "liquidation_type")
    private Integer liquidationType;
    /**
     * 二级所属类目ID
     */
    @JSONField(name = "category_code")
    private Integer categoryCode;

    /**
     * 支付宝商户终端费率（‰），范围：3.8~100。注：若无调整费率权限时勿传，否则会报错
     */
    @JSONField(name = "alipay_fee_rate")
    private String alipayFeeRate;
    /**
     * 微信商户终端费率（‰），范围：3.8~100。注：若无调整费率权限时勿传，否则会报错
     */
    @JSONField(name = "wx_fee_rate")
    private String wxFeeRate;
    /**
     * 银联商户终端费率（‰），范围：3.8~100。注：若无调整费率权限时勿传，否则会报错
     */
    @JSONField(name = "union_fee_rate")
    private String unionFeeRate;

    /**
     * 省编码
     */
    @JSONField(name = "biz_province_code")
    private String bizProvinceCode;
    /**
     * 省名称
     */
    @JSONField(name = "biz_province_name")
    private String bizProvinceName;
    /**
     * 市编码
     */
    @JSONField(name = "biz_city_code")
    private String bizCityCode;
    /**
     * 市名称
     */
    @JSONField(name = "biz_city_name")
    private String bizCityName;
    /**
     * 区编码
     */
    @JSONField(name = "biz_area_code")
    private String bizAreaCode;
    /**
     * 区名称
     */
    @JSONField(name = "biz_area_name")
    private String bizAreaName;
    /**
     * 地址
     */
    @JSONField(name = "biz_address")
    private String bizAddress;

}
