/**
 * fshows.com
 * Copyright (C) 2013-2019 All Rights Reserved.
 */
package com.frt.fubeiopenapisdk.request.account.detail;

import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.annotation.JSONType;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.List;

/**
 * @author zhoujp
 * @version SubAccountMemberAddListParam.java, v 0.1 2019-11-06 16:51 zhoujp
 */
@Data
@JSONType(naming = PropertyNamingStrategy.SnakeCase)
public class SubAccountMemberAddListRequest implements Serializable {
    private static final long serialVersionUID = 8494832104280613164L;

    /**
     * 分账接收方编号
     */
    @NotBlank(message = "不能为空")
    private String accountId;

    /**
     * 协议图片，调用上传图片接口先上传到付呗服务器获取到图片链接，多张图片以”,“隔开
     * 最多支持20张图片
     */
    @Length(max = 4000, message = "协议图片超长")
    private String agreementImg;

    private List<SubAccountMemberAddRuleListRequest> ruleList;

}