/*
 * ailike.com
 * Copyright (C) 2022-2025 All Rights Reserved.
 */
package com.frt.fubeiopenapisdk.request.account.detail;

import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.annotation.JSONType;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author zhangling
 * @version AccountFixAmountDetailRequest.java, v 0.1 2025-11-04 10:05 zhangling
 */
@Data
@JSONType(naming = PropertyNamingStrategy.SnakeCase)
public class AccountFixAmountDetailRequest implements Serializable {
    private static final long serialVersionUID = 956946086270475294L;
    /**
     * 分账接收方id
     */
    private String accountId;
    /**
     * 分账金额（元），精确到0.01，范围：0.01 ~ 1000000
     */
    private BigDecimal shareAmount;
}