/**
 * fshows.com
 * Copyright (C) 2013-2019 All Rights Reserved.
 */
package com.frt.fubeiopenapisdk.request.account;

import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.annotation.JSONType;
import com.frt.fubeiopenapisdk.request.FubeiBizRequest;
import com.frt.fubeiopenapisdk.request.account.detail.SubAccountMemberAddListRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * @author zhoujp
 * @version SubAccountMemberAddParam.java, v 0.1 2019-11-06 16:44 zhoujp
 */
@Data
@EqualsAndHashCode(callSuper = true)
@JSONType(naming = PropertyNamingStrategy.SnakeCase)
public class FubeiSubAccountMemberAddRequest extends FubeiBizRequest {
    private static final long serialVersionUID = -7535704726502584426L;

    /**
     * 分账组id
     */
    @NotBlank(message = "不能为空")
    private String groupId;

    private List<SubAccountMemberAddListRequest> dataList;
}