/*
 * ailike.com
 * Copyright (C) 2022-2025 All Rights Reserved.
 */
package com.frt.fubeiopenapisdk.request.account;

import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.annotation.JSONType;
import com.frt.fubeiopenapisdk.request.FubeiBizRequest;
import com.frt.fubeiopenapisdk.request.account.detail.AccountFixAmountDetailRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author zhangling
 * @version FubeiAccountBalanceQueryRequest.java, v 0.1 2025-11-04 09:23 zhangling
 */
@Data
@EqualsAndHashCode(callSuper = true)
@JSONType(naming = PropertyNamingStrategy.SnakeCase)
public class FubeiAccountFixAmountRequest extends FubeiBizRequest {
    private static final long serialVersionUID = -88328359641335352L;
    /**
     * 付呗商户号,与account_id二选一，以商户级接入时无需填写
     */
    private String merchantId;
    /**
     * 外部系统订单号
     */
    @NotBlank(message = "商户订单号不能为空")
    private String merchantOrderSn;
    /**
     * 分账总金额（元），精确到0.01，范围：0.01 ~ 1000000
     */
    @NotNull(message = "分账总金额不能为空")
    private BigDecimal totalShareAmount;
    /**
     * 分账完成回调地址
     */
    private String notifyUrl;
    /**
     * 分账列表
     */
    @NotNull(message = "分账列表不能为空")
    private List<AccountFixAmountDetailRequest> dataList;
}