package com.frt.fubeiopenapisdk.apienum;

import com.frt.fubeiopenapisdk.request.account.FubeiAccountBalanceQueryRequest;
import com.frt.fubeiopenapisdk.request.account.FubeiAccountFixAmountRequest;
import com.frt.fubeiopenapisdk.request.account.FubeiAccountFixQueryRequest;
import com.frt.fubeiopenapisdk.request.account.FubeiSubAccountIncomeRequest;
import com.frt.fubeiopenapisdk.request.account.FubeiSubAccountMemberAddRequest;
import com.frt.fubeiopenapisdk.request.account.FubeiSubAccountReceiveQueryRequest;
import com.frt.fubeiopenapisdk.request.account.FubeiSubAccountUpdateRequest;
import com.frt.fubeiopenapisdk.response.account.FubeiAccountBalanceQueryResponse;
import com.frt.fubeiopenapisdk.response.account.FubeiAccountFixAmountResponse;
import com.frt.fubeiopenapisdk.response.account.FubeiAccountFixQueryResponse;
import com.frt.fubeiopenapisdk.response.account.FubeiSubAccountIncomeResponse;
import com.frt.fubeiopenapisdk.response.account.FubeiSubAccountMemberAddResponse;
import com.frt.fubeiopenapisdk.response.account.FubeiSubAccountReceiveQueryResponse;
import com.frt.fubeiopenapisdk.response.account.FubeiSubAccountUpdateResponse;
import com.fshows.sdk.core.client.base.definition.IApiDefinition;
import lombok.Getter;

@Getter
public enum FubeiAccountApiDefinitionEnum implements IApiDefinition {

    ACCOUNT_BALANCE_QUERY("账户余额查询",
            "openapi.agent.account.balance.query",
            "1.0",
            "POST",
            FubeiAccountBalanceQueryRequest.class,
            FubeiAccountBalanceQueryResponse.class),

    ACCOUNT_FIXED_AMOUNT("按固定金额分账（余额）",
            "openapi.agent.account.fixed.amount",
            "1.0",
            "POST",
            FubeiAccountFixAmountRequest.class,
            FubeiAccountFixAmountResponse.class),

    ACCOUNT_FIXED_QUERY("分账查询",
            "openapi.agent.account.fixed.query",
            "1.0",
            "POST",
            FubeiAccountFixQueryRequest.class,
            FubeiAccountFixQueryResponse.class),
    SUB_ACCOUNT_INCOME(
            "分账接收方入驻",
            "openapi.agent.account.subaccount.income",
            "1.0",
            "POST",
            FubeiSubAccountIncomeRequest.class,
            FubeiSubAccountIncomeResponse.class
    ),
    SUB_ACCOUNT_INCOME_QUERY(
            "分账接收方查询",
            "openapi.agent.account.subaccount.receive.query",
            "1.0",
            "POST",
            FubeiSubAccountReceiveQueryRequest.class,
            FubeiSubAccountReceiveQueryResponse.class
    ),
    SUB_ACCOUNT_MODIFY(
            "分账接收方结算卡信息修改",
            "openapi.agent.account.subaccount.update",
            "1.0",
            "POST",
            FubeiSubAccountUpdateRequest.class,
            FubeiSubAccountUpdateResponse.class
    ),
    SUB_ACCOUNT_MEMBER_ADD(
            "分账组添加分账成员",
            "openapi.agent.account.subaccount.addmember",
            "1.0",
            "POST",
            FubeiSubAccountMemberAddRequest.class,
            FubeiSubAccountMemberAddResponse.class
    ),
    ;

    /**
     * 接口名称
     */
    private final String name;

    /**
     * 交易编码
     */
    private final String trancode;

    /**
     * 接口版本
     */
    private final String version;

    /**
     * 接口类型
     */
    private final String interfaceType;

    /**
     * 请求业务参数的Class类型
     */
    private final Class requestClass;

    /**
     * 响应业务参数的Class类型
     */
    private final Class responseClass;

    FubeiAccountApiDefinitionEnum(String name,
                                  String trancode,
                                  String version,
                                  String interfaceType,
                                  Class requestClass,
                                  Class responseClass) {
        this.name = name;
        this.trancode = trancode;
        this.version = version;
        this.interfaceType = interfaceType;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
    }

    @Override
    public String getApiURI() {
        return trancode;
    }

    @Override
    public String getVersion() {
        return version;
    }

    @Override
    public Class getRequestClass() {
        return requestClass;
    }

    @Override
    public Class getResponseClass() {
        return responseClass;
    }
}
