/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fsframework.extend.extension;

import cn.hutool.core.collection.CollectionUtil;
import com.fshows.fsframework.core.utils.LogUtil;
import com.fshows.fsframework.extend.extension.ExtensionRepository;
import com.fshows.fsframework.extend.extension.IExtensionPoint;
import com.fshows.fsframework.extend.extension.annotation.IExtension;
import com.fshows.fsframework.extend.extension.factory.ExtensionFactory;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ExtensionBootstrap
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(ExtensionBootstrap.class);
    private ApplicationContext applicationContext;
    @Resource
    private ExtensionFactory extensionFactory;
    @Resource
    private ExtensionRepository extensionRepository;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @PostConstruct
    public void init() {
        Map extensionBeans = this.applicationContext.getBeansWithAnnotation(IExtension.class);
        if (CollectionUtil.isEmpty((Map)extensionBeans)) {
            return;
        }
        extensionBeans.values().forEach(extension -> this.extensionFactory.doRegister((IExtensionPoint)extension));
        LogUtil.info((Logger)log, (String)"init >> \u4e1a\u52a1\u573a\u666f\u76f8\u5173\u6269\u5c55\u70b9\u6ce8\u518c\u5b8c\u6210\uff0c\u6ce8\u518c\u6570\u91cf: \u3010{}\u3011", (Object[])new Object[]{this.extensionRepository.getAll().size()});
    }
}

