/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fsframework.extend.idgen.worker;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.fshows.fsframework.extend.idgen.exception.WorkerIdAssignException;
import com.fshows.fsframework.extend.idgen.worker.WorkerIdAssigner;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigWorkerIdAssigner
implements WorkerIdAssigner {
    private static final Logger log = LoggerFactory.getLogger(ConfigWorkerIdAssigner.class);
    private String config;
    private Set<String> nativeIpSet;
    private long workerId;

    public ConfigWorkerIdAssigner(String config, Set<String> nativeIpSet) {
        this.config = config;
        this.nativeIpSet = nativeIpSet;
        this.workerId = this.getWorkerId(config, nativeIpSet);
    }

    private long getWorkerId(String config, Set<String> nativeIpSet) {
        log.info("ConfigWorkerIdAssigner >> workerId\u914d\u7f6e\u89e3\u6790\u5668 >> nativeIpSet={}, config={}", nativeIpSet, (Object)config);
        if (StringUtils.isBlank((CharSequence)config)) {
            throw new WorkerIdAssignException("workerId\u751f\u6210\u5668-\u673a\u5668ID\u914d\u7f6e-\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtil.isEmpty(nativeIpSet)) {
            throw new WorkerIdAssignException("workerId\u751f\u6210\u5668-\u672c\u673aIP-\u4e0d\u80fd\u4e3a\u7a7a");
        }
        JSONObject workerConfigModel = JSONObject.parseObject((String)config);
        Optional<Long> workerIdOpt = nativeIpSet.stream().filter(arg_0 -> ((JSONObject)workerConfigModel).containsKey(arg_0)).map(arg_0 -> ((JSONObject)workerConfigModel).getLong(arg_0)).findFirst();
        if (!workerIdOpt.isPresent()) {
            log.error("ConfigWorkerIdAssigner >> workerId\u914d\u7f6e\u89e3\u6790\u5f02\u5e38 >> \u914d\u7f6e\u4e2d\u672a\u89e3\u6790\u5230\u5f53\u524dIP\u5bf9\u5e94\u7684\u673a\u5668ID >> nativeIpSet={}, config={}", nativeIpSet, (Object)config);
            throw new WorkerIdAssignException("workerId\u914d\u7f6e\u89e3\u6790\u5f02\u5e38,\u914d\u7f6e\u4e2d\u672a\u89e3\u6790\u5230\u5f53\u524dIP\u5bf9\u5e94\u7684\u673a\u5668ID,\u8bf7\u68c0\u67e5\u673a\u5668ID\u914d\u7f6e");
        }
        return workerIdOpt.get();
    }

    @Override
    public long assignWorkerId() {
        return this.workerId;
    }
}

