/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fsframework.extend.ons.client;

import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.Producer;
import com.aliyun.openservices.ons.api.SendResult;
import com.aliyun.openservices.ons.api.exception.ONSClientException;
import com.fshows.fsframework.core.utils.LogUtil;
import com.fshows.fsframework.core.utils.SystemClock;
import com.fshows.fsframework.extend.ons.client.IProducer;
import com.fshows.fsframework.extend.ons.client.ProduceBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProducerService
implements IProducer {
    private static final Logger log = LoggerFactory.getLogger(ProducerService.class);
    private ProduceBean produce;

    public ProducerService(ProduceBean bean) {
        this.produce = bean;
    }

    private boolean pushMessage(Message message) {
        Producer producer = this.produce.getProducer();
        try {
            SendResult sendResult = producer.send(message);
            LogUtil.info((Logger)log, (String)"pushMessage >> \u6d88\u606f\u961f\u5217,\u53d1\u9001\u6d88\u606f\u6210\u529f\uff01key={}, SendResult={}", (Object[])new Object[]{message.getKey(), sendResult});
            return true;
        }
        catch (ONSClientException e) {
            LogUtil.error((Logger)log, (String)"pushMessage >> \u6d88\u606f\u961f\u5217,\u53d1\u9001\u6d88\u606f\u5931\u8d25\uff01key = {}", (Throwable)e, (Object[])new Object[]{message.getKey()});
            return false;
        }
    }

    @Override
    public boolean sendMessage(String msg) {
        return this.sendMessage(msg, msg);
    }

    @Override
    public boolean sendMessage(String key, String msg) {
        if (msg == null) {
            LogUtil.warn((Logger)log, (String)"sendMessage >> \u7f3a\u5c11\u751f\u4ea7\u8005\u914d\u7f6e\u4fe1\u606f Msg =null");
            return false;
        }
        Message message = new Message(this.produce.getTopicId(), this.produce.getTag(), msg.getBytes());
        message.setKey(this.produce.getKeyPrefix() + key);
        return this.pushMessage(message);
    }

    @Override
    public boolean sendDelayMessage(String msg, int dliverTime) {
        if (msg == null) {
            LogUtil.warn((Logger)log, (String)"sendDelayMessage >> \u7f3a\u5c11\u751f\u4ea7\u8005\u914d\u7f6e\u4fe1\u606f Msg =null");
            return false;
        }
        Message message = new Message(this.produce.getTopicId(), this.produce.getTag(), msg.getBytes());
        message.setKey(this.produce.getKeyPrefix() + msg);
        message.setStartDeliverTime(SystemClock.millisClock().now() + (long)dliverTime);
        return this.pushMessage(message);
    }

    @Override
    public boolean sendDelayMessage(String key, String body, int dliverTime) {
        if (body == null || key == null) {
            LogUtil.warn((Logger)log, (String)"\u7f3a\u5c11\u751f\u4ea7\u8005\u914d\u7f6e\u4fe1\u606f Msg ={},key={}", (Object[])new Object[]{body, key});
            return false;
        }
        Message message = new Message(this.produce.getTopicId(), this.produce.getTag(), body.getBytes());
        message.setKey(this.produce.getKeyPrefix() + key);
        message.setStartDeliverTime(SystemClock.millisClock().now() + (long)dliverTime);
        return this.pushMessage(message);
    }

    private boolean pushMessageRetry(Message message) {
        Producer producer = this.produce.getProducer();
        try {
            SendResult sendResult = producer.send(message);
            LogUtil.info((Logger)log, (String)"pushMessageRetry >> \u6d88\u606f\u961f\u5217,\u53d1\u9001\u6d88\u606f\u6210\u529f\uff01key={}, SendResult={}", (Object[])new Object[]{message.getKey(), sendResult});
            return true;
        }
        catch (ONSClientException e) {
            LogUtil.warn((Logger)log, (String)"pushMessageRetry >> \u6d88\u606f\u961f\u5217,\u53d1\u9001\u6d88\u606f\u5931\u8d25,\u53d1\u8d77\u91cd\u8bd5\u4e00\u6b21\uff01key = {}", (Throwable)e, (Object[])new Object[]{message.getKey()});
            return this.pushMessage(message);
        }
    }

    @Override
    public boolean sendMessageRetry(String msg) {
        return this.sendMessageRetry(msg, msg);
    }

    @Override
    public boolean sendMessageRetry(String key, String msg) {
        if (msg == null) {
            LogUtil.warn((Logger)log, (String)"\u7f3a\u5c11\u751f\u4ea7\u8005\u914d\u7f6e\u4fe1\u606f Msg =null");
            return false;
        }
        Message message = new Message(this.produce.getTopicId(), this.produce.getTag(), msg.getBytes());
        message.setKey(this.produce.getKeyPrefix() + key);
        return this.pushMessageRetry(message);
    }

    @Override
    public boolean sendDelayMessageRetry(String msg, int dliverTime) {
        if (msg == null) {
            LogUtil.warn((Logger)log, (String)"sendDelayMessageRetry >> \u7f3a\u5c11\u751f\u4ea7\u8005\u914d\u7f6e\u4fe1\u606f Msg =null");
            return false;
        }
        Message message = new Message(this.produce.getTopicId(), this.produce.getTag(), msg.getBytes());
        message.setKey(this.produce.getKeyPrefix() + msg);
        message.setStartDeliverTime(SystemClock.millisClock().now() + (long)dliverTime);
        return this.pushMessageRetry(message);
    }

    @Override
    public boolean sendDelayMessageRetry(String key, String body, int dliverTime) {
        if (body == null || key == null) {
            LogUtil.warn((Logger)log, (String)"sendDelayMessageRetry >> \u7f3a\u5c11\u751f\u4ea7\u8005\u914d\u7f6e\u4fe1\u606f Msg ={},key={}", (Object[])new Object[]{body, key});
            return false;
        }
        Message message = new Message(this.produce.getTopicId(), this.produce.getTag(), body.getBytes());
        message.setStartDeliverTime(SystemClock.millisClock().now() + (long)dliverTime);
        message.setKey(this.produce.getKeyPrefix() + key);
        return this.pushMessageRetry(message);
    }

    @Override
    public void start() {
        this.produce.getProducer().start();
    }

    @Override
    public void shutdown() {
        this.produce.getProducer().shutdown();
    }
}

