/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.easypay.sdk.request.refund;

import com.fshows.easypay.sdk.base.SignFiled;
import com.fshows.easypay.sdk.request.EasyPayBizRequest;
import com.fshows.easypay.sdk.response.base.EasyPayRefundBizResponse;
import com.fshows.easypay.sdk.response.refund.EasyPayRefundQueryBizResponse;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * @author zhangmj
 * @version EasyPayRefundQueryRequest.java, v 0.1 2023-10-30 16:57 zhangmj
 */
@Data
public class EasyPayRefundQueryBizRequest extends EasyPayBizRequest<EasyPayRefundQueryBizResponse> {

    private static final long serialVersionUID = 4288860300779798779L;

    /**
     * 交易商户号(必填)
     */
    @NotBlank
    @SignFiled(needJoin = false)
    private String orgMerCode;

    /**
     * 交易终端号(必填)
     */
    @NotBlank
    @SignFiled(needJoin = false)
    private String orgTermNo;

    /**
     * 下游机构商户唯一标识(选填)
     */
    @SignFiled(needJoin = false)
    private String orgSmercode;

    /**
     * 产品流水
     */
    @SignFiled(needJoin = false)
    private String prodTrace;

    /**
     * 交易流水号
     * 35位不定长，建议按照如下规则：orgId 前四位+后四位+yyyyMMddhhmmss+自定义 （需要保证唯一）
     */
    @SignFiled(needJoin = false)
    private String orgTrace;

    /**
     * 业务产品码（原成功交易请求流水)
     */
    @SignFiled(needJoin = false)
    private String prodCode;

    /**
     * GPS坐标系（WGS84、GCJ02、BD09）
     */
    @SignFiled(needJoin = false)
    private String orgGpstype;

    /**
     * 经度
     */
    @SignFiled(needJoin = false)
    private String orgLongitude;

    /**
     * 维度
     */
    @SignFiled(needJoin = false)
    private String orgLatitude;

    /**
     * 基站信息
     */
    @SignFiled(needJoin = false)
    private String orgBasestation;

    /**
     * 交易设备ip
     */
    @SignFiled(needJoin = false)
    private String orgDeviceIp;

    /**
     * 请求方自定义信息
     */
    @SignFiled(needJoin = false)
    private String orgInfo;

    /**
     * 系统应答
     */
    @SignFiled(needJoin = false)
    private String sysRetCode;

    /**
     * 原商户订单号
     */
    @NotBlank
    @SignFiled(needJoin = true)
    private String oriOrgTrace;

    @Override
    public Class<EasyPayRefundQueryBizResponse> getResponseClass() {
        return EasyPayRefundQueryBizResponse.class;
    }
}