/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.easypay.sdk.request.merchant;

import com.fshows.easypay.sdk.request.base.EasyPayMerchantBaseRequest;
import com.fshows.easypay.sdk.response.merchant.MerchantUpdateResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author zhubo
 * @version MerchantUpdateRequest.java, v 0.1 2023-11-04 13:54 zhubo
 */
@Data
public class MerchantUpdateRequest extends EasyPayMerchantBaseRequest<MerchantUpdateResponse> {
    private static final long serialVersionUID = 4587772878278065309L;

    /**
     * 回调url
     */
    private String backUrl;

    /**
     * 报文类型
     */
    private String messageType = "ALTERMER";

    /**
     * 商户唯一标识
     */
    @NotBlank
    private String merTrace;

    /**
     * 该字段为机构上送的操作流水号，机构唯一；用于查询操作结果；
     */
    @NotBlank
    @Length(max = 20, message = "operaTrace操作流水号长度不能超过20")
    private String operaTrace;

    /**
     * 商家信息
     */
    @NotBlank
    private String merInfo;

    /**
     * 附加信息
     */
    @NotBlank
    private String plusInfo;

    /**
     * 营业执照信息
     */
    @NotBlank
    private String licInfo;

    /**
     * 产品信息
     * json 格式字符串 (list) 特殊场景下使用
     */
    private List<String> prodList;

    /**
     * 图片信息
     */
    @NotNull
    private List<String> picInfoList;

    /**
     * json 格式字符串，需和易生约定特殊使用
     */
    private String customInfo;

    @Override
    public Class<MerchantUpdateResponse> getResponseClass() {
        return MerchantUpdateResponse.class;
    }
}
