package com.fshows.ccbpay.enums.trade;

import com.fshows.ccbpay.client.base.ICcbPayApiDefinition;
import com.fshows.ccbpay.enums.base.CcbApiTypeEnum;
import com.fshows.ccbpay.request.trade.order.CcbOrderQueryRequest;
import com.fshows.ccbpay.request.trade.order.CcbQueryOrderStatusRequest;
import com.fshows.ccbpay.request.trade.pay.CcbAlipayJsApiPayRequest;
import com.fshows.ccbpay.request.trade.pay.CcbScanCardPayRequest;
import com.fshows.ccbpay.request.trade.pay.CcbWxJsApiPayRequest;
import com.fshows.ccbpay.response.trade.order.CcbOrderQueryResponse;
import com.fshows.ccbpay.response.trade.order.CcbQueryOrderStatusResponse;
import com.fshows.ccbpay.response.trade.pay.CcbAlipayJsApiPayResponse;
import com.fshows.ccbpay.response.trade.pay.CcbScanCardPayResponse;
import com.fshows.ccbpay.response.trade.pay.CcbWxJsApiPayResponse;

/**
 * 建行开放平台交易相关API
 *
 * @author liluqing
 * @version CcbPayTradeApiDefinitionEnum.java, v 0.1 2022-03-01 21:53 liluqing
 */
public enum CcbPayTradeApiDefinitionEnum implements ICcbPayApiDefinition {
    PRE_ORDER_CREATE(
            "主扫交易（统一下单接口）",
            "530590",
            null,
            null,
            CcbApiTypeEnum.DIRECT_CONNECT
    ),
    SCAN_CARD_CREATE(
            "被扫交易（付款码支付）",
            "",
            CcbScanCardPayRequest.class,
            CcbScanCardPayResponse.class,
            CcbApiTypeEnum.DIRECT_CONNECT
    ),
    ORDER_QUERY(
            "订单查询接口",
            "",
            CcbOrderQueryRequest.class,
            CcbOrderQueryResponse.class,
            CcbApiTypeEnum.DIRECT_CONNECT
    ),
    QUERY_ORDER_STATUS(
            "订单状态轮询接口",
            "PAY101",
            CcbQueryOrderStatusRequest.class,
            CcbQueryOrderStatusResponse.class,
            CcbApiTypeEnum.DIRECT_CONNECT
    ),
    WX_ORDER_CREATE(
            "微信主扫交易",
            "",
            CcbWxJsApiPayRequest.class,
            CcbWxJsApiPayResponse.class,
            CcbApiTypeEnum.DIRECT_CONNECT
    ),
    ALI_ORDER_CREATE(
            "支付宝主扫交易",
            "",
            CcbAlipayJsApiPayRequest.class,
            CcbAlipayJsApiPayResponse.class,
            CcbApiTypeEnum.DIRECT_CONNECT
            )
    ;

    /**
     * 接口名称
     */
    private String name;
    /**
     * 接口uri子资源路径
     */
    private String apiSubURI;
    /**
     * 请求业务参数的Class类型
     */
    private Class requestClass;
    /**
     * 响应业务参数的Class类型
     */
    private Class responseClass;

    /**
     * API类型
     */
    private CcbApiTypeEnum ccbApiTypeEnum;


    CcbPayTradeApiDefinitionEnum(String name,
                                 String apiSubURI,
                                 Class requestClass,
                                 Class responseClass,
                                 CcbApiTypeEnum ccbApiTypeEnum) {
        this.name = name;
        this.apiSubURI = apiSubURI;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
        this.ccbApiTypeEnum = ccbApiTypeEnum;
    }

    @Override
    public String getApiSubURI() {
        return apiSubURI;
    }

    @Override
    public Class getRequestClass() {
        return requestClass;
    }

    @Override
    public Class getResponseClass() {
        return responseClass;
    }
}