/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.ark.spring.boot.starter.util;

import com.fshows.ark.spring.boot.starter.core.mq.base.FsMqCustomConfig;
import org.springframework.context.ApplicationContext;
import org.springframework.util.StringUtils;

public class ConfigUtil {
    public static String getProperty(String el, ApplicationContext ctx) {
        if (ConfigUtil.isDynamicProperty(el)) {
            String result = ctx.getEnvironment().resolvePlaceholders(el);
            return ConfigUtil.isDynamicProperty(result) ? null : result;
        }
        return el;
    }

    public static boolean isDynamicProperty(String key) {
        if (StringUtils.startsWithIgnoreCase((String)key, (String)"#{") && StringUtils.endsWithIgnoreCase((String)key, (String)"}")) {
            return true;
        }
        return StringUtils.startsWithIgnoreCase((String)key, (String)"${") && StringUtils.endsWithIgnoreCase((String)key, (String)"}");
    }

    public static String isDynamicConfigKey(String el) {
        return ConfigUtil.isDynamicProperty(el) ? el : null;
    }

    public static String getDynamicKey(String key) {
        if (ConfigUtil.isDynamicProperty(key)) {
            int i = key.indexOf(":");
            if (i > -1) {
                return key.substring(2, i);
            }
            return key.substring(2, key.length() - 1);
        }
        return null;
    }

    public static FsMqCustomConfig getFsMqCustomConfig(ApplicationContext ctx) {
        try {
            return (FsMqCustomConfig)ctx.getBean(FsMqCustomConfig.class);
        }
        catch (Exception e) {
            return null;
        }
    }
}

