/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.ark.spring.boot.starter.extend.mq.interceptor;

import com.fshows.ark.spring.boot.starter.core.mq.base.FsMessage;
import com.fshows.ark.spring.boot.starter.core.mq.base.consumer.FsConsumerInterceptor;
import com.fshows.ark.spring.boot.starter.util.TraceIdGenerator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.core.annotation.Order;

@Order(value=1)
public class TraceIdConsumeInterceptor
implements FsConsumerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(TraceIdConsumeInterceptor.class);

    @Override
    public void beforeConsume(FsMessage fsMessage) {
        Map<Object, Object> extendMap = fsMessage.getExtendParam();
        if (extendMap != null) {
            String traceId = extendMap.get("TRACE_ID") == null ? TraceIdGenerator.generate() : (String)extendMap.get("TRACE_ID");
            MDC.put((String)"TRACE_ID", (String)traceId);
        }
    }

    @Override
    public void afterConsume(FsMessage fsMessage, boolean consumeResult) {
        MDC.remove((String)"TRACE_ID");
    }
}

