/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.ark.spring.boot.starter.core.mq.rocketmq.producer;

import com.fshows.ark.spring.boot.starter.core.mq.rocketmq.producer.RocketProducerFactoryBean;
import java.lang.annotation.Annotation;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

public class ClassPathProducerScanner
extends ClassPathBeanDefinitionScanner {
    private static final Logger log = LoggerFactory.getLogger(ClassPathProducerScanner.class);
    private Class<? extends Annotation> annotationClass;
    private Class<? extends RocketProducerFactoryBean> producerFactoryBeanClass = RocketProducerFactoryBean.class;

    public ClassPathProducerScanner(BeanDefinitionRegistry registry) {
        super(registry, false);
    }

    public void registerFilters() {
        this.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(this.annotationClass, true, true));
        this.addExcludeFilter((metadataReader, metadataReaderFactory) -> {
            String className = metadataReader.getClassMetadata().getClassName();
            return className.endsWith("package-info");
        });
    }

    public Set<BeanDefinitionHolder> doScan(String ... basePackages) {
        Set beanDefinitions = super.doScan(basePackages);
        if (beanDefinitions.isEmpty()) {
            log.warn("Rocket MQ \u751f\u4ea7\u8005\u6ce8\u89e3\u914d\u7f6e\u626b\u63cf >> \u6ca1\u6709\u4ece\u6307\u5b9a\u7684basePackages\u76ee\u5f55\u626b\u63cf\u5230MQ\u751f\u4ea7\u8005\u914d\u7f6e!basePackages={}", (Object[])basePackages);
            return beanDefinitions;
        }
        this.processBeanDefinitions(beanDefinitions);
        return beanDefinitions;
    }

    private void processBeanDefinitions(Set<BeanDefinitionHolder> beanDefinitions) {
        for (BeanDefinitionHolder holder : beanDefinitions) {
            GenericBeanDefinition definition = (GenericBeanDefinition)holder.getBeanDefinition();
            String beanClassName = definition.getBeanClassName();
            log.debug("\u521b\u5efaRocketProducerFactoryBean >> beanName={}, beanClass={}", (Object)holder.getBeanName(), (Object)beanClassName);
            definition.getConstructorArgumentValues().addGenericArgumentValue((Object)beanClassName);
            definition.setBeanClass(this.producerFactoryBeanClass);
            definition.setAutowireMode(2);
        }
    }

    protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
        return beanDefinition.getMetadata().isInterface() && beanDefinition.getMetadata().isIndependent();
    }

    protected boolean checkCandidate(String beanName, BeanDefinition beanDefinition) {
        if (!super.checkCandidate(beanName, beanDefinition)) {
            log.warn("RocketProducerFactoryBean\u521b\u5efa>> Spring\u5bb9\u5668\u4e2d\u5df2\u5b58\u5728\u76f8\u540c\u7684\u540d\u79f0\u7684bean,\u672c\u6b21\u5c06\u8df3\u8fc7\u8be5bean!  beanName={}, beanClass={}", (Object)beanName, (Object)beanDefinition.getBeanClassName());
            return false;
        }
        return true;
    }

    public void setAnnotationClass(Class<? extends Annotation> annotationClass) {
        this.annotationClass = annotationClass;
    }

    public void setProducerFactoryBeanClass(Class<? extends RocketProducerFactoryBean> producerFactoryBeanClass) {
        this.producerFactoryBeanClass = producerFactoryBeanClass;
    }
}

