/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package
        com.fshows.ark.spring.boot.starter.util;

/**
 *
 * @author liluqing
 * @version ByteUtil.java, v 0.1 2024-05-29 21:02
 */
public class FsByteUtil {

    /**
     * 合并两个byte数组
     *
     * @param array1
     * @param array2
     * @return
     */
    public static byte[] mergeByteArrays(byte[] array1, byte[] array2) {
        // 创建一个新的数组，其长度是两个数组长度之和
        byte[] mergedArray = new byte[array1.length + array2.length];

        // 复制第一个数组到新的数组的起始位置
        System.arraycopy(array1, 0, mergedArray, 0, array1.length);

        // 复制第二个数组到新的数组的后续位置
        System.arraycopy(array2, 0, mergedArray, array1.length, array2.length);
        return mergedArray;
    }

    /**
     * 将int的低16位拆分成两个8位的byte部分
     *
     * @param value
     * @return
     */
    public static byte[] splitBytes(int value) {
        // 将keyId低16位的数值拆分成两个8位的部分
        byte lowByte = (byte) (value & 0xFF); // 获取低8位
        byte highByte = (byte) ((value >> 8) & 0xFF); // 获取高8位

        return new byte[]{lowByte, highByte};
    }

    /**
     * 将两个byte在int的低16位合并成一个int
     * @param high
     * @param low
     * @return
     */
    public static int mergeBytes(byte high, byte low) {
        // 将byte转换为int并且保证是无符号的
        int highInt = high;
        int lowInt = low;

        // 将高位byte左移8位，然后与低位byte按位或
        return (highInt << 8) | lowInt;
    }
}