/**
 * fshows.com
 * Copyright (C) 2013-2021 All Rights Reserved.
 */
package
        com.fshows.ark.spring.boot.starter.enums;

/**
 *
 * @author liluqing
 * @version RocketProducerSendTypeEnum.java, v 0.1 2021-08-29 13:22
 */
public enum ProducerSendTypeEnum {

    /**
     * 枚举列表
     */
    SYNC("同步发送", "SYNC"),
    ASYNC("异步发送", "ASYNC"),
    ONE_WAY("Oneway形式，服务器不应答，无法保证消息是否成功到达服务器", "ONE_WAY"),
    ;

    private String name;
    private String value;

    ProducerSendTypeEnum(String name, String value) {
        this.name = name;
        this.value = value;
    }

    /**
     * Getter method for property <tt>name</tt>.
     *
     * @return property value of name
     */
    public String getName() {
        return name;
    }

    /**
     * Getter method for property <tt>value</tt>.
     *
     * @return property value of value
     */
    public String getValue() {
        return value;
    }

    public static ProducerSendTypeEnum getByValue(String value) {
        ProducerSendTypeEnum[] valueList = ProducerSendTypeEnum.values();
        for (ProducerSendTypeEnum v : valueList) {
            if (v.getValue().equals(value)) {
                return v;
            }
        }
        return null;
    }
}