/**
 * fshows.com
 * Copyright (C) 2013-2021 All Rights Reserved.
 */
package
        com.fshows.ark.spring.boot.starter.enums;

import com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsProducerInvoke;
import com.fshows.ark.spring.boot.starter.core.mq.rocketmq.producer.invoke.AliyunMessageInvoke;
import com.fshows.ark.spring.boot.starter.core.mq.rocketmq.producer.invoke.ContentMsgkeyStrInvoke;
import com.fshows.ark.spring.boot.starter.core.mq.rocketmq.producer.invoke.ContentStrInvoke;
import com.fshows.ark.spring.boot.starter.core.mq.rocketmq.producer.invoke.FsMessageInvoke;

/**
 * 生产者方式@RocketMessage的映射类型
 *
 * @author liluqing
 * @version RocketProducerInvokerEnum.java, v 0.1 2021-08-29 12:11
 */
public enum ProducerParamTypeEnum {

    /**
     * 直接传入消息内容，不指定Key
     */
    CONTENT_STR(new String[]{"java.lang.String"},
            new ProducerSendTypeEnum[]{
                ProducerSendTypeEnum.SYNC,
                ProducerSendTypeEnum.ASYNC,
                ProducerSendTypeEnum.ONE_WAY
            },
            new ContentStrInvoke()),
    CONTENT_STR_ASYNC( new String[]{
            "java.lang.String",
            "com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsSendSuccessCallback",
            "com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsSendErrorCallback"},
            new ProducerSendTypeEnum[]{ProducerSendTypeEnum.ASYNC},
            new ContentStrInvoke()),
    CONTENT_STR_ASYNC_SUCCESS( new String[]{
            "java.lang.String",
            "com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsSendSuccessCallback"},
            new ProducerSendTypeEnum[]{ProducerSendTypeEnum.ASYNC},
            new ContentStrInvoke()),
    CONTENT_STR_ASYNC_ERROR( new String[]{"java.lang.String",
            "com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsSendErrorCallback"},
            new ProducerSendTypeEnum[]{ProducerSendTypeEnum.ASYNC},
            new ContentStrInvoke()),


    /**
     * 在仅需要普通消息的情况下,直接传入消息的key即可
     */
    CONTENT_MSGKEY_STR(new String[]{
            "java.lang.String", "java.lang.String"},
            new ProducerSendTypeEnum[]{
                ProducerSendTypeEnum.SYNC,
                ProducerSendTypeEnum.ASYNC,
                ProducerSendTypeEnum.ONE_WAY
            },
            new ContentMsgkeyStrInvoke()
    ),
    CONTENT_MSGKEY_STR_ASYNC( new String[]{
            "java.lang.String",
            "java.lang.String",
            "com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsSendSuccessCallback",
            "com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsSendErrorCallback"},
            new ProducerSendTypeEnum[]{ProducerSendTypeEnum.ASYNC},
            new ContentMsgkeyStrInvoke()),
    CONTENT_MSGKEY_STR_ASYNC_SUCCESS( new String[]{"java.lang.String",
            "java.lang.String",
            "com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsSendSuccessCallback"},
            new ProducerSendTypeEnum[]{ProducerSendTypeEnum.ASYNC},
            new ContentMsgkeyStrInvoke()),
    CONTENT_MSGKEY_STR_ASYNC_ERROR( new String[]{"java.lang.String",
            "java.lang.String",
            "com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsSendErrorCallback"},
            new ProducerSendTypeEnum[]{ProducerSendTypeEnum.ASYNC},
            new ContentMsgkeyStrInvoke()),

    /**
     * 使用fs封装的messge以便解耦和
     */
    FS_MESSAGE( new String[]{"com.fshows.ark.spring.boot.starter.core.mq.base.FsMessage"},
            new ProducerSendTypeEnum[]{
                ProducerSendTypeEnum.SYNC,
                ProducerSendTypeEnum.ASYNC,
                ProducerSendTypeEnum.ONE_WAY
            },
            new FsMessageInvoke()
    ),
    FS_MESSAGE_ASYNC( new String[]{
            "com.fshows.ark.spring.boot.starter.core.mq.base.FsMessage",
            "com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsSendSuccessCallback",
            "com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsSendErrorCallback"},
            new ProducerSendTypeEnum[]{ProducerSendTypeEnum.ASYNC},
            new FsMessageInvoke()),
    FS_MESSAGE_ASYNC_SUCCESS( new String[]{
            "com.fshows.ark.spring.boot.starter.core.mq.base.FsMessage",
            "com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsSendSuccessCallback"},
            new ProducerSendTypeEnum[]{ProducerSendTypeEnum.ASYNC},
            new FsMessageInvoke()),
    FS_MESSAGE_ASYNC_ERROR( new String[]{
            "com.fshows.ark.spring.boot.starter.core.mq.base.FsMessage",
            "com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsSendErrorCallback"},
            new ProducerSendTypeEnum[]{ProducerSendTypeEnum.ASYNC},
            new FsMessageInvoke()),


    /**
     * 使用阿里云的message入参,以便直接使用阿里云sdk提供的某些特殊功能
     */
    ALIYUN_MESSAGE(new String[]{"com.aliyun.openservices.ons.api.Message"},
            new ProducerSendTypeEnum[]{
                ProducerSendTypeEnum.SYNC,
                ProducerSendTypeEnum.ASYNC,
                ProducerSendTypeEnum.ONE_WAY
            },
            new AliyunMessageInvoke()
    ),
    ALIYUN_ASYNC(new String[]{
            "com.aliyun.openservices.ons.api.Message",
            "com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsSendSuccessCallback",
            "com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsSendErrorCallback"},
            new ProducerSendTypeEnum[]{ProducerSendTypeEnum.ASYNC},
            new AliyunMessageInvoke()),
    ALIYUN_ASYNC_SUCCESS( new String[]{
            "com.aliyun.openservices.ons.api.Message",
            "com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsSendSuccessCallback"},
            new ProducerSendTypeEnum[]{ProducerSendTypeEnum.ASYNC},
            new AliyunMessageInvoke()),
    ALIYUN_ASYNC_ERROR(new String[]{
            "com.aliyun.openservices.ons.api.Message",
            "com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsSendErrorCallback"},
            new ProducerSendTypeEnum[]{ProducerSendTypeEnum.ASYNC},
            new AliyunMessageInvoke()),

    ;

    /**
     * 方法允许的入参类型
     */
    private String[] paramsClass;

    /**
     * 支持的消息发送类型
     */
    private ProducerSendTypeEnum[] sendTypeEnum;

    /**
     * 生产者委托封装类
     */
    private FsProducerInvoke fsProducerInvoke;

    ProducerParamTypeEnum(
            String[] paramsClass,
            ProducerSendTypeEnum[] sendTypeEnum,
            FsProducerInvoke fsProducerInvoke
    ) {
        this.paramsClass = paramsClass;
        this.sendTypeEnum = sendTypeEnum;
        this.fsProducerInvoke = fsProducerInvoke;
    }

    /**
     * 根据参数类别获取参数列表枚举
     *
     * @param paramTypes
     * @return
     */
    public static ProducerParamTypeEnum getByParamsClass(Class[] paramTypes) {
        if (paramTypes == null || paramTypes.length == 0) {
            return null;
        }
        // 循环验证方法的参数类型，ProducerParamTypeEnum中定义了所有允许的参数类型
        for (ProducerParamTypeEnum paramTypeEnum : ProducerParamTypeEnum.values()) {
            String[] targetParamTypeArr = paramTypeEnum.getParamsClass();
            // 如果参数个数不一致则说明不符合当前参数定义
            if (targetParamTypeArr.length != paramTypes.length) {
                continue;
            }
            for (int i = 0; i < targetParamTypeArr.length; i++) {
                if (paramTypes[i] == null || !targetParamTypeArr[i].equals(paramTypes[i].getName())) {
                    break;
                }
                if (targetParamTypeArr.length - 1 == i) {
                    return  paramTypeEnum;
                }
            }
        }
        return null;
    }

    public String[] getParamsClass() {
        return paramsClass;
    }

    public ProducerSendTypeEnum[] getSendTypeEnum() {
        return sendTypeEnum;
    }

    public FsProducerInvoke getFsProducerInvoke() {
        return fsProducerInvoke;
    }
}