/**
 * fshows.com
 * Copyright (C) 2013-2021 All Rights Reserved.
 */
package
        com.fshows.ark.spring.boot.starter.enums;

/**
 *
 * @author liluqing
 * @version MsgTypeEnum.java, v 0.1 2021-12-22 18:47
 */
public enum MsgTypeEnum {

    /**
     * 枚举列表
     */
    NOMAL_MESSAGE("普通消息", 0),
    DELAY_MESSAGE("延迟消息消息", 1),
    TRANSACTION_MESSAGE("事务消息", 2),;

    private String name;
    private int value;

    MsgTypeEnum(String name, int value) {
        this.name = name;
        this.value = value;
    }

    /**
     * Getter method for property <tt>name</tt>.
     *
     * @return property value of name
     */
    public String getName() {
        return name;
    }

    /**
     * Getter method for property <tt>value</tt>.
     *
     * @return property value of value
     */
    public int getValue() {
        return value;
    }

    public static MsgTypeEnum getByValue(int value) {
        MsgTypeEnum[] valueList = MsgTypeEnum.values();
        for (MsgTypeEnum v : valueList) {
            if (v.getValue() == value) {
                return v;
            }
        }
        return null;
    }
}