package com.fshows.ark.spring.boot.starter.enums;

/**
 * 消费者返回值类型
 *
 * @author liluqing
 * @version RocketConsumerReturnTypeEnum.java, v 0.1 2019-09-20 10:55
 */
public enum ConsumerReturnTypeEnum {
    /**
     * 枚举列表
     */
    VOID("无返回值", "void"),
    ALIYUN_ACTION("阿里云的action", "com.aliyun.openservices.ons.api.Action"),
    BOOLEAN("消费结果（ture-消费成功  false-消费失败）", "java.lang.Boolean");

    private String name;
    private String value;

    ConsumerReturnTypeEnum(String name, String value) {
        this.name = name;
        this.value = value;
    }

    /**
     * Getter method for property <tt>name</tt>.
     *
     * @return property value of name
     */
    public String getName() {
        return name;
    }

    /**
     * Getter method for property <tt>value</tt>.
     *
     * @return property value of value
     */
    public String getValue() {
        return value;
    }

    public static ConsumerReturnTypeEnum getByValue(String value) {
        ConsumerReturnTypeEnum[] valueList = ConsumerReturnTypeEnum.values();
        for (ConsumerReturnTypeEnum v : valueList) {
            if (v.getValue().equalsIgnoreCase(value)) {
                return v;
            }
        }
        return null;
    }
}