/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package
        com.fshows.ark.spring.boot.starter.core.sensitive.model;

import com.fshows.ark.spring.boot.starter.core.sensitive.enums.AlgorithmTypeEnum;
import lombok.Data;

/**
 *
 * @author liluqing
 * @version EncryptAlgorithmModel.java, v 0.1 2024-05-27 14:55
 */
@Data
public class SecretKeyModel {


    /**
     * 密钥名称
     */
    public String secretName;

    /**
     * 密钥ID
     * （使用2个字节表示,表达范围为十进制的0-65535的数字）
     */
    public int keyId;

    /**
     * 算法类型,例如: RSA,AES,SM4 等
     */
    public AlgorithmTypeEnum algorithmType;

    /**
     * 公钥（非对称机密时才有值）
     */
    public byte[] publicKey;

    /**
     * 私钥
     */
    public byte[] privateKey;
}