package com.fshows.ark.spring.boot.starter.core.sensitive.enums;

import lombok.Getter;

/**
 * @author liluqing
 * @version AlgorithmTypeEnum.java, v 0.1 2024-05-27 15:07 liluqing
 */
@Getter
public enum AlgorithmTypeEnum {
    SM4("SM4", 1),
    AES("AES", 2),
    MD5("MD5", 3),
    ;

    private String name;

    /**
     * 算法类型code
     * （由于该code由两个字节表示(无符号位)，所以他在十进制的取值范围是2^16 即0~65536的数字）
     *
     */
    private Integer value;

    AlgorithmTypeEnum(String name, Integer value) {
        this.name = name;
        this.value = value;
    }

    public static AlgorithmTypeEnum getByValue(Integer value) {
        AlgorithmTypeEnum[] valueList = AlgorithmTypeEnum.values();
        for (AlgorithmTypeEnum v : valueList) {
            if (v.getValue().equals(value)) {
                return v;
            }
        }
        return null;
    }

    public static AlgorithmTypeEnum getByName(String name) {
        AlgorithmTypeEnum[] valueList = AlgorithmTypeEnum.values();
        for (AlgorithmTypeEnum v : valueList) {
            if (v.getName().equalsIgnoreCase(name)) {
                return v;
            }
        }
        return null;
    }

}