/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package
        com.fshows.ark.spring.boot.starter.core.sensitive.encrypt;

import com.fshows.ark.spring.boot.starter.core.sensitive.enums.AlgorithmTypeEnum;
import com.fshows.ark.spring.boot.starter.core.sensitive.model.SecretKeyModel;

/**
 * 密钥管理器
 *
 * @author liluqing
 * @version FieldEncryptFactory.java, v 0.1 2024-05-27 14:39
 */
public interface SecretKeyManage {

    /**
     * 根据密钥版本和算法类型获取实际密钥信息
     *
     * @param keyId
     * @param algorithmType
     * @return
     */
    SecretKeyModel getSecretKey(String keyId, AlgorithmTypeEnum algorithmType);

    /**
     * 根据名称查询密钥信息
     *
     * @param secretName
     * @return
     */
    SecretKeyModel getSecretKeyByName(String secretName);

    /**
     * 获取当前应用敏感字段加密主密钥
     *
     * @return
     */
    SecretKeyModel getMainEncryptSecretKey();

    /**
     * 获取当前应用检索字段加密主密钥
     * （用于检索的字段可能一般不能更换，且对密文长度铭感，可能会使用不可逆的数据摘要算法，所以，密钥单独设置）
     * @return
     */
    SecretKeyModel getSearchKeywordsSecret();


}

