/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package
        com.fshows.ark.spring.boot.starter.core.sensitive.encrypt;

import com.fshows.ark.spring.boot.starter.core.sensitive.enums.AlgorithmTypeEnum;
import com.fshows.ark.spring.boot.starter.core.sensitive.model.SecretKeyModel;

/**
 * 加密字段策略
 *
 * @author liluqing
 * @version IFieldEncryptStrategy.java, v 0.1 2024-05-27 14:40
 */
public interface IFieldEncryptStrategy {

    /**
     * 数据加密
     *
     * @param plaintext 明文
     * @return 密文
     */
    byte[] encrypt(byte[] plaintext, SecretKeyModel model);

    /**
     * 数据解密
     *
     * @param ciphertext 密文
     * @return 明文
     */
    byte[] decrypt(byte[] ciphertext, SecretKeyModel model);

    /**
     * 获取算法类型
     * @return
     */
    AlgorithmTypeEnum getAlgorithmTypeEnum();
}