/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package
        com.fshows.ark.spring.boot.starter.core.sensitive.encrypt;

import com.fshows.ark.spring.boot.starter.core.sensitive.enums.AlgorithmTypeEnum;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 *
 * @author liluqing
 * @version FieldEncryptFactory.java, v 0.1 2024-05-27 14:39
 */
@Component
public class FieldEncryptFactory implements ApplicationContextAware {

    /**
     * 加密策略缓存
     */
    private final Map<AlgorithmTypeEnum, IFieldEncryptStrategy> ENCRYPT_STRATEGY_CACHE_MAP = new ConcurrentHashMap<>();
    private ApplicationContext applicationContext;

    /**
     * 初始化密钥缓存
     */
    @PostConstruct
    public void initMap() {
        Map<String, IFieldEncryptStrategy> map = applicationContext.getBeansOfType(IFieldEncryptStrategy.class);
        if (map.isEmpty()) {
            return;
        }
        for(IFieldEncryptStrategy iFieldEncryptStrategy : map.values()) {
            ENCRYPT_STRATEGY_CACHE_MAP.put(iFieldEncryptStrategy.getAlgorithmTypeEnum(), iFieldEncryptStrategy);
        }
    }

    /**
     * 获取某一算法的实现策略
     *
     * @param algorithmTypeEnum
     * @return
     */
    public IFieldEncryptStrategy getFieldEncryptStrategy(AlgorithmTypeEnum algorithmTypeEnum) {
        return ENCRYPT_STRATEGY_CACHE_MAP.get(algorithmTypeEnum);
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}