package com.fshows.ark.spring.boot.starter.core.sensitive;

import com.fshows.ark.spring.boot.starter.core.sensitive.encrypt.interceptor.DecryptInterceptor;
import com.fshows.ark.spring.boot.starter.core.sensitive.encrypt.interceptor.EncryptInterceptor;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.stereotype.Component;

/**
 * SqlSessionFactoryBean对象后置处理器
 *
 * @author zhaoxumin
 * @version SqlSessionFactoryBeanPostProcessor.java, v 0.1 2024-05-20 11:55 zhaoxumin
 */
@Component
public class SqlSessionFactoryBeanPostProcessor implements BeanPostProcessor {

    @Autowired
    private EncryptInterceptor encryptInterceptor;

    @Autowired
    private DecryptInterceptor decryptInterceptor;

    @Override
    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    @Override
    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof SqlSessionFactory) {
            SqlSessionFactory sqlSessionFactory = (SqlSessionFactory) bean;
            Configuration configuration = sqlSessionFactory.getConfiguration();
            configuration.addInterceptor(encryptInterceptor);
            configuration.addInterceptor(decryptInterceptor);
        }
        return bean;
    }
}
