/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.ark.spring.boot.starter.core.sensitive;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.asymmetric.KeyType;
import cn.hutool.crypto.asymmetric.RSA;
import cn.hutool.crypto.digest.DigestAlgorithm;
import cn.hutool.crypto.digest.Digester;
import cn.hutool.crypto.symmetric.SymmetricAlgorithm;
import cn.hutool.crypto.symmetric.SymmetricCrypto;
import com.fshows.ark.spring.boot.starter.core.sensitive.enums.AlgorithmTypeEnum;
import com.fshows.ark.spring.boot.starter.util.Sm4Util;

/**
 * @author liluqing
 * @version Sm4EncryptionExample.java, v 0.1 2024-05-27 15:18
 */
public class Sm4EncryptionExample {

    public static void main(String[] args) throws Exception {
        String content = "浙江省杭州市余杭区未来科技城万达广场A座27楼1909上课时地方流口水的防守对方考试的分数考的分数";
        byte[] contentByte = content.getBytes(CharsetUtil.CHARSET_UTF_8);


        //随机生成密钥
        byte[] key = SecureUtil.generateKey(SymmetricAlgorithm.AES.getValue()).getEncoded();

        //构建
        SymmetricCrypto aes = new SymmetricCrypto(SymmetricAlgorithm.AES, key);

        //加密
        byte[] encrypt = aes.encrypt(contentByte);


        System.out.println("明文：" + content);
        System.out.println("长度：" + content.length());
        System.out.println("AES-Base64密文：" + Base64.encode(encrypt));
        System.out.println("长度：" + Base64.encode(encrypt).length());

        // 生成RSA密钥对
        RSA rsa = new RSA();

        // 使用公钥加密
        String encryptedData = rsa.encryptBase64(contentByte, KeyType.PublicKey);
        System.out.println("RSA-Base64密文：" + encryptedData);
        System.out.println("长度：" + encryptedData.length());

        String seed = "123456";

        Digester md5 = new Digester(DigestAlgorithm.MD5);
        String digestHex = md5.digestHex(seed);
        byte[] mkey = md5.digest(digestHex+seed);


        //加密
        byte[] sm4Encrypt = Sm4Util.encrypt(contentByte, mkey);
        System.out.println("SM4-Base64密文：" + Base64.encode(sm4Encrypt));
        System.out.println("长度：" + Base64.encode(sm4Encrypt).length());

        // 解密
        byte[] sm4Decrypt = Sm4Util.decrypt(sm4Encrypt, mkey);
        System.out.println("解密：" + new String(sm4Decrypt));

        AlgorithmTypeEnum  algorithmTypeEnum = AlgorithmTypeEnum.SM4;
        Integer keyId = 1;

        Integer AlgorithmType = algorithmTypeEnum.getValue();

        int intValue = 1234; // 假设这是你的int变量

        // 提取低16位的数值
        int low16Bits = intValue & 0xFFFF;

        // 将低16位的数值拆分成两个8位的部分
        byte lowByte = (byte) (low16Bits & 0xFF); // 获取低8位
        byte highByte = (byte) ((low16Bits >> 8) & 0xFF); // 获取高8位

        System.out.println("intValue: " + intValue);
        System.out.println("Low byte: " + lowByte); // 输出低8位的值
        System.out.println("High byte: " + highByte); // 输出高8位的值
        System.out.println("txt (二进制) :     " + intToBinaryString32Bit(intValue));
        System.out.println("High byte(二进制): " + "                " + byteToBinaryString(highByte)); // 输出高8位的值
        System.out.println("Low byte(二进制) : " + "                " + "        " + byteToBinaryString(lowByte)); // 输出低8位的值
        // 重新合并byte
        int newIntValue = mergeBytes(highByte, lowByte);
        System.out.println("newIntValue: " + newIntValue);
        System.out.println("newIntValue (二进制) : " + intToBinaryString32Bit(newIntValue));
        System.out.println("High byte(二进制):     " + "                " + byteToBinaryString(highByte)); // 输出高8位的值
        System.out.println("Low byte(二进制) :     " + "                " + "        " + byteToBinaryString(lowByte)); // 输出低8位的值
    }

    /**
     * 将int类型数字转换为32位二进制字符串
     * @param number 需要转换的整数
     * @return 表示该整数的32位二进制字符串
     */
    public static String intToBinaryString32Bit(int number) {
        String binaryString = Integer.toBinaryString(number);
        // 使用String.format补足前面的0，达到32位
        return String.format("%32s", binaryString).replace(' ', '0');
    }
    /**
     * 将byte类型数字转换为8位二进制字符串
     * @param number 需要转换的字节
     * @return 表示该字节的8位二进制字符串
     */
    public static String byteToBinaryString(byte number) {
        // 使用位与操作和移位操作获取每一位
        StringBuilder binaryString = new StringBuilder(8);
        for (int i = 7; i >= 0; i--) {
            binaryString.append((number >> i) & 1);
        }
        return binaryString.toString();
    }

    public static int mergeBytes(byte high, byte low) {
        // 将byte转换为int并且保证是无符号的
        int highInt = high & 0xFF;
        int lowInt = low & 0xFF;

        // 将高位byte左移8位，然后与低位byte按位或
        return (highInt << 8) | lowInt;
    }
}