/**
 * fshows.com
 * Copyright (C) 2013-2021 All Rights Reserved.
 */
package
        com.fshows.ark.spring.boot.starter.core.mq.rocketmq.producer.transaction;

import com.fshows.ark.spring.boot.starter.core.mq.base.FsMessageConvert;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsMessageSendContext;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsSendResult;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.IFshowsProducer;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.TransactionCommitCallback;
import org.springframework.transaction.support.TransactionSynchronization;

/**
 * 实现spring的事务同步器，可在提交前后插入一些额外操作
 *
 * @author liluqing
 * @version DefaultTransactionSynchronization.java, v 0.1 2021-09-27 18:46
 */
public class DefaultTransactionSynchronization implements TransactionSynchronization {

    /**
     * 消息上下文
     */
    private FsMessageSendContext fsMessageSendContext;

    /**
     * 消息处理成功回调
     */
    private TransactionCommitCallback transactionCommitCallback;

    public DefaultTransactionSynchronization(FsMessageSendContext context, TransactionCommitCallback transactionCommitCallback) {
        this.fsMessageSendContext = context;
        this.transactionCommitCallback = transactionCommitCallback;
    }

    @Override
    public void afterCompletion(int status) {
        // 只有事务提交,才算是支付成功
        boolean isSuccess = TransactionSynchronization.STATUS_COMMITTED == status;
        FsSendResult fsSendResult = FsMessageConvert.buildSendResult(fsMessageSendContext.getFsMessage(), isSuccess);
        // 执行消息发送回调处理
        transactionCommitCallback.commitCallback(fsMessageSendContext, fsSendResult);
    }
}