/**
 * fshows.com
 * Copyright (C) 2013-2021 All Rights Reserved.
 */
package
        com.fshows.ark.spring.boot.starter.core.mq.rocketmq.producer.invoke;

import com.fshows.ark.spring.boot.starter.core.mq.base.FsMessage;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsProducerInvoke;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsSendErrorCallback;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsSendSuccessCallback;
import com.fshows.ark.spring.boot.starter.core.mq.rocketmq.producer.RocketSendMessageMethodModel;
import com.fshows.ark.spring.boot.starter.enums.ProducerParamTypeEnum;

/**
 * 消息content和消息key参数Invoke
 *
 * @author liluqing
 * @version ContentMsgkeyStrInvoke.java, v 0.1 2021-08-29 22:00
 */
public class ContentMsgkeyStrInvoke implements FsProducerInvoke {
    /**
     * 构建fsmessage
     *
     * @param sendMessageMethodModel
     * @param args
     * @return
     */
    @Override
    public FsMessage buildFsMessage(RocketSendMessageMethodModel sendMessageMethodModel, Object[] args) {
        FsMessage fsMessage = new FsMessage();
        fsMessage.setTopic(sendMessageMethodModel.getTopic());
        fsMessage.setTag(sendMessageMethodModel.getTag());
        fsMessage.setKey((String) args[0]);
        fsMessage.setContent((String) args[1]);
        fsMessage.setSendTime(sendMessageMethodModel.getSendTime());
        return fsMessage;
    }

    @Override
    public FsSendSuccessCallback buildFsSendSuccessCallback(RocketSendMessageMethodModel sendMessageMethodModel, Object[] args) {
        if (ProducerParamTypeEnum.CONTENT_MSGKEY_STR_ASYNC.equals(sendMessageMethodModel.getParamTypeEnum())) {
            return (FsSendSuccessCallback) args[2];
        }
        if (ProducerParamTypeEnum.CONTENT_MSGKEY_STR_ASYNC_SUCCESS.equals(sendMessageMethodModel.getParamTypeEnum())) {
            return (FsSendSuccessCallback) args[2];
        }
        return null;
    }

    @Override
    public FsSendErrorCallback buildFsSendErrorCallback(RocketSendMessageMethodModel sendMessageMethodModel, Object[] args) {
        if (ProducerParamTypeEnum.CONTENT_MSGKEY_STR_ASYNC.equals(sendMessageMethodModel.getParamTypeEnum())) {
            return (FsSendErrorCallback) args[3];
        }
        if (ProducerParamTypeEnum.CONTENT_MSGKEY_STR_ASYNC_ERROR.equals(sendMessageMethodModel.getParamTypeEnum())) {
            return (FsSendErrorCallback) args[2];
        }
        return null;
    }
}