/**
 * fshows.com
 * Copyright (C) 2013-2021 All Rights Reserved.
 */
package
        com.fshows.ark.spring.boot.starter.core.mq.rocketmq.producer.invoke;

import com.aliyun.openservices.ons.api.Message;
import com.fshows.ark.spring.boot.starter.constant.MQConstant;
import com.fshows.ark.spring.boot.starter.core.mq.base.FsMessage;
import com.fshows.ark.spring.boot.starter.core.mq.base.FsMessageConvert;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsProducerInvoke;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsSendErrorCallback;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsSendSuccessCallback;
import com.fshows.ark.spring.boot.starter.core.mq.rocketmq.producer.RocketSendMessageMethodModel;
import com.fshows.ark.spring.boot.starter.enums.ProducerParamTypeEnum;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * 阿里云sdk message参数Invoke
 *
 * @author liluqing
 * @version AliyunMessageInvoke.java, v 0.1 2021-08-29 22:02
 */
public class AliyunMessageInvoke implements FsProducerInvoke {

    @Override
    public FsMessage buildFsMessage(RocketSendMessageMethodModel sendMessageMethodModel, Object[] args) {
        if (args[0] == null) {
            return null;
        }
        // 补充参数,消息投递的目标的topic和tag以注解中的源数据为准
        Message message = (Message) args[0];
        message.setTopic(sendMessageMethodModel.getTopic());
        message.setTag(sendMessageMethodModel.getTag());
        message.setStartDeliverTime(sendMessageMethodModel.getSendTime());

        FsMessage fsMessage = FsMessageConvert.convertFsMessage(message);
        Map<Object, Object> extendParam = fsMessage.getExtendParam();
        if (extendParam == null) {
            extendParam = new ConcurrentHashMap<>();
        }
        extendParam.put(MQConstant.ALIYUN_ORIGINAL_MESSAGE, message);
        fsMessage.setExtendParam(extendParam);
        return fsMessage;
    }

    /**
     * 获取消息发送成功回调处理对象
     *
     * @param args
     * @return
     */
    @Override
    public FsSendSuccessCallback buildFsSendSuccessCallback(RocketSendMessageMethodModel sendMessageMethodModel, Object[] args) {
        if (ProducerParamTypeEnum.ALIYUN_ASYNC_SUCCESS.equals(sendMessageMethodModel.getParamTypeEnum())) {
            return (FsSendSuccessCallback) args[1];
        }
        if (ProducerParamTypeEnum.ALIYUN_ASYNC.equals(sendMessageMethodModel.getParamTypeEnum())) {
            return (FsSendSuccessCallback) args[1];
        }
        return null;
    }

    /**
     * 获取消息发送失败回调处理对象
     *
     * @param args
     * @return
     */
    @Override
    public FsSendErrorCallback buildFsSendErrorCallback(RocketSendMessageMethodModel sendMessageMethodModel, Object[] args) {
        if (ProducerParamTypeEnum.ALIYUN_ASYNC.equals(sendMessageMethodModel.getParamTypeEnum())) {
            return (FsSendErrorCallback) args[2];
        }
        if (ProducerParamTypeEnum.ALIYUN_ASYNC_ERROR.equals(sendMessageMethodModel.getParamTypeEnum())) {
            return (FsSendErrorCallback) args[1];
        }
        return null;
    }
}