/**
 * fshows.com
 * Copyright (C) 2013-2021 All Rights Reserved.
 */
package
        com.fshows.ark.spring.boot.starter.core.mq.rocketmq.producer;

import com.fshows.ark.spring.boot.starter.core.mq.rocketmq.producer.transaction.TransactionMessageMethodModel;
import com.fshows.ark.spring.boot.starter.enums.ProducerParamTypeEnum;
import com.fshows.ark.spring.boot.starter.enums.ProducerReturnTypeEnum;
import com.fshows.ark.spring.boot.starter.enums.ProducerSendTypeEnum;
import com.fshows.ark.spring.boot.starter.enums.ProducerTypeEnum;
import lombok.Builder;
import lombok.Getter;
import lombok.ToString;

import java.lang.reflect.Method;

/**
 * 生产者方法元数据
 *
 * @author liluqing
 * @version RocketProducerModel.java, v 0.1 2021-08-19 16:58
 */
@Builder
@Getter
@ToString
public class RocketSendMessageMethodModel {

    /**
     * 当前生产者组的group id
     */
    private String groupId;

    /**
     * 消息的topic
     */
    private String topic;

    /**
     * 消息的tag
     */
    private String tag;

    /**
     * msg key前缀
     *  （消息的key都会默认添加该前缀）
     *
     * @return
     */
    private String msgKeyPrefix;

    /**
     * 消息延迟发送时间(毫秒)
     */
    private String delayTime;

    /**
     * 事务消息特有属性
     */
    private TransactionMessageMethodModel transactionMessageMethodModel;

    /**
     * 消息生产类型
     */
    private ProducerTypeEnum producerTypeEnum;

    /**
     * 消息发送方式
     */
    private ProducerSendTypeEnum sendTypeEnum;

    /**
     * 原始接口的发送方法引用
     */
    private Method interfaceMethod;

    /**
     * 入参类型
     */
    private ProducerParamTypeEnum paramTypeEnum;

    /**
     * 响应参数类型
     */
    private ProducerReturnTypeEnum returnTypeEnum;

    /**
     * 发送失败时是否抛出异常：true-抛出异常    false: 将异常封装成FsSendResult结果正常返回
     *
     * @return
     */
    private boolean sendErrorThrowEx = false;

    /**
     * 获取消息发送时间
     *
     * @return
     */
    public long getSendTime() {
        if (delayTime == null || delayTime.length() == 0) {
            return 0;
        }
        return System.currentTimeMillis() + Long.parseLong(delayTime);
    }
}