/**
 * fshows.com
 * Copyright (C) 2013-2021 All Rights Reserved.
 */
package
        com.fshows.ark.spring.boot.starter.core.mq.rocketmq.producer;

import com.fshows.ark.spring.boot.starter.core.mq.base.producer.IProducerProxyFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * rocketmq生产者代理工厂bean
 *
 * @author liluqing
 * @version RocketProducerFatoryBean.java, v 0.1 2021-08-15 22:35
 */
public class RocketProducerFactoryBean<T> implements FactoryBean<T> {

    @Autowired
    private IProducerProxyFactory producerProxyFactory;

    /**
     * 生产者接口
     */
    private Class<T> producerInterface;


    public RocketProducerFactoryBean() {
    }

    public RocketProducerFactoryBean(Class<T> producerInterface) {
        this.producerInterface = producerInterface;
    }

    @Override
    public T getObject() throws Exception {
        // 通过工厂方法创建动态创建代理对象
        T instance = producerProxyFactory.bulidRocketProducerProxy(producerInterface);
        return instance;
    }

    @Override
    public Class<?> getObjectType() {
        return producerInterface;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }
}