/**
 * fshows.com
 * Copyright (C) 2013-2021 All Rights Reserved.
 */
package
        com.fshows.ark.spring.boot.starter.core.mq.rocketmq.producer;

import com.aliyun.openservices.ons.api.OnExceptionContext;
import com.aliyun.openservices.ons.api.SendCallback;
import com.aliyun.openservices.ons.api.SendResult;
import com.fshows.ark.spring.boot.starter.core.mq.base.FsMessageConvert;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsMessageSendContext;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsSendErrorCallback;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsSendExceptionHolder;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsSendResult;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsSendSuccessCallback;
import com.fshows.ark.spring.boot.starter.core.mq.rocketmq.interceptor.ProducerInterceptorActuator;

/**
 * 阿里云消息异步回调时间包装
 *
 *
 * @author liluqing
 * @version AliyunSendCallBack.java, v 0.1 2021-08-24 20:05
 */
public class AliyunSendCallBackWrap implements SendCallback {

    /**
     * 支付成功的处理事件
     */
    private FsSendSuccessCallback sendSuccessCallback;

    /**
     * 支付失败处理事件
     */
    private FsSendErrorCallback fsSendErrorCallback;

    /**
     * 原始消息
     */
    private FsMessageSendContext context;

    /**
     * 拦截器执行器
     */
    private ProducerInterceptorActuator producerInterceptorActuator;

    public AliyunSendCallBackWrap(FsSendSuccessCallback sendSuccessCallback, FsSendErrorCallback fsSendErrorCallback) {
        this.sendSuccessCallback = sendSuccessCallback;
        this.fsSendErrorCallback = fsSendErrorCallback;
    }

    public AliyunSendCallBackWrap(FsSendSuccessCallback sendSuccessCallback, FsSendErrorCallback fsSendErrorCallback, FsMessageSendContext context, ProducerInterceptorActuator producerInterceptorActuator) {
        this.sendSuccessCallback = sendSuccessCallback;
        this.fsSendErrorCallback = fsSendErrorCallback;
        this.producerInterceptorActuator = producerInterceptorActuator;
        this.context = context;
    }

    @Override
    public void onSuccess(SendResult sendResult) {
        if (sendSuccessCallback != null) {
            FsSendResult result = FsMessageConvert.convertFsSendResult(sendResult);
            if (producerInterceptorActuator != null) {
                // 执行拦截器后置处理
                producerInterceptorActuator.doAfterSend(context, result);
            }
            // 执行异步回调
            sendSuccessCallback.onSuccess(result, context);
        }
    }

    @Override
    public void onException(OnExceptionContext onExceptionContext) {
        if (fsSendErrorCallback != null) {
            FsSendResult result = FsMessageConvert.convertFsSendResult(onExceptionContext);
            if (producerInterceptorActuator != null) {
                // 执行拦截器后置处理
                producerInterceptorActuator.doAfterSend(this.context, result);
            }
            // 执行异常回调
            FsSendExceptionHolder exceptionHolder = FsMessageConvert.convertFsSendExceptionContext(onExceptionContext);
            fsSendErrorCallback.onException(exceptionHolder, this.context);
        }
    }
}